/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.jdbc.JdbcCompiledQuery;
import org.apache.metamodel.jdbc.JdbcCompiledQueryLease;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataSet.class);
    private final JdbcCompiledQuery _compiledQuery;
    private final JdbcCompiledQueryLease _lease;
    private final Statement _statement;
    private final ResultSet _resultSet;
    private final JdbcDataContext _jdbcDataContext;
    private final Connection _connection;
    private Row _row;
    private boolean _closed;

    public JdbcDataSet(Query query, JdbcDataContext jdbcDataContext, Connection connection, Statement statement, ResultSet resultSet) {
        super(query.getSelectClause().getItems());
        if (query == null || statement == null || resultSet == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this._jdbcDataContext = jdbcDataContext;
        this._connection = connection;
        this._statement = statement;
        this._resultSet = resultSet;
        this._closed = false;
        this._compiledQuery = null;
        this._lease = null;
    }

    public JdbcDataSet(JdbcCompiledQuery compiledQuery, JdbcCompiledQueryLease lease, ResultSet resultSet) {
        super(compiledQuery.getSelectItems());
        if (compiledQuery == null || lease == null || resultSet == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this._compiledQuery = compiledQuery;
        this._lease = lease;
        this._jdbcDataContext = null;
        this._connection = null;
        this._statement = null;
        this._resultSet = resultSet;
        this._closed = false;
    }

    public Row getRow() {
        return this._row;
    }

    public boolean next() throws MetaModelException {
        try {
            boolean result = this._resultSet.next();
            if (result) {
                Object[] values = new Object[this.getHeader().size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.getValue(this._resultSet, i);
                    try {
                        if (!this._resultSet.wasNull()) continue;
                        values[i] = null;
                        continue;
                    }
                    catch (Exception e) {
                        logger.debug("Could not invoke wasNull() method on resultset, error message: {}", (Object)e.getMessage());
                    }
                }
                this._row = new DefaultRow(this.getHeader(), values);
            } else {
                this._row = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "get next record in resultset");
        }
    }

    private Object getValue(ResultSet resultSet, int i) throws SQLException {
        Column column;
        SelectItem selectItem = this.getHeader().getSelectItem(i);
        int columnIndex = i + 1;
        if (selectItem.getAggregateFunction() == null && (column = selectItem.getColumn()) != null) {
            IQueryRewriter queryRewriter = this._jdbcDataContext == null ? new DefaultQueryRewriter(null) : this._jdbcDataContext.getQueryRewriter();
            return queryRewriter.getResultSetValue(resultSet, columnIndex, column);
        }
        return resultSet.getObject(columnIndex);
    }

    public void close() {
        if (this._closed) {
            return;
        }
        FileHelper.safeClose((Object[])new Object[]{this._resultSet});
        if (this._jdbcDataContext != null) {
            FileHelper.safeClose((Object[])new Object[]{this._statement});
            this._jdbcDataContext.close(this._connection);
        }
        if (this._compiledQuery != null) {
            this._compiledQuery.returnLease(this._lease);
        }
        this._closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }
}

