/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.metamodel.jdbc.JdbcCompiledQueryLease;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.util.FileHelper;

final class JdbcCompiledQueryLeaseFactory
implements PoolableObjectFactory<JdbcCompiledQueryLease> {
    private final JdbcDataContext _dataContext;
    private final String _sql;

    public JdbcCompiledQueryLeaseFactory(JdbcDataContext dataContext, String sql) {
        this._dataContext = dataContext;
        this._sql = sql;
    }

    public JdbcCompiledQueryLease makeObject() throws Exception {
        try {
            Connection connection = this._dataContext.getConnection();
            PreparedStatement statement = connection.prepareStatement(this._sql);
            JdbcCompiledQueryLease lease = new JdbcCompiledQueryLease(connection, statement);
            return lease;
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "preparing statement");
        }
    }

    public void destroyObject(JdbcCompiledQueryLease lease) throws Exception {
        FileHelper.safeClose((Object[])new Object[]{lease.getStatement()});
        Connection connection = lease.getConnection();
        this._dataContext.close(connection);
    }

    public boolean validateObject(JdbcCompiledQueryLease lease) {
        return true;
    }

    public void activateObject(JdbcCompiledQueryLease obj) throws Exception {
    }

    public void passivateObject(JdbcCompiledQueryLease obj) throws Exception {
    }
}

