/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.hbase.HBaseColumn;
import org.apache.metamodel.hbase.HBaseDataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HBaseTable
extends MutableTable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HBaseTable.class);
    private final transient HBaseDataContext _dataContext;
    private final transient ColumnType _defaultRowKeyColumnType;

    public HBaseTable(HBaseDataContext dataContext, SimpleTableDef tableDef, MutableSchema schema, ColumnType defaultRowKeyColumnType) {
        super(tableDef.getName(), TableType.TABLE, (Schema)schema);
        this._dataContext = dataContext;
        this._defaultRowKeyColumnType = defaultRowKeyColumnType;
        this.addColumns(tableDef);
    }

    private void addColumns(SimpleTableDef tableDef) {
        String[] columnNames = tableDef.getColumnNames();
        if (columnNames == null || columnNames.length == 0) {
            logger.info("No user-defined columns specified for table {}. Columns will be auto-detected.");
        } else {
            boolean idColumnFound;
            ColumnType[] columnTypes = tableDef.getColumnTypes();
            int indexOfIDColumn = HBaseTable.getIndexOfIdColumn(columnNames);
            boolean bl = idColumnFound = indexOfIDColumn != -1;
            if (idColumnFound) {
                this.addColumn("_id", columnTypes[indexOfIDColumn], indexOfIDColumn + 1);
            } else {
                this.addColumn("_id", this._defaultRowKeyColumnType, 1);
            }
            for (int i = 0; i < columnNames.length; ++i) {
                if ("_id".equals(columnNames[i])) continue;
                if (idColumnFound) {
                    this.addColumn(columnNames[i], columnTypes[i], i + 1);
                    continue;
                }
                this.addColumn(columnNames[i], columnTypes[i], i + 2);
            }
        }
    }

    private static int getIndexOfIdColumn(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (!"_id".equals(columnNames[i])) continue;
            return i;
        }
        return -1;
    }

    private void addColumn(String columnName, ColumnType columnType, int columnNumber) {
        this.addColumn((Column)new HBaseColumn(columnName, null, (Table)this, columnNumber, columnType));
    }

    protected synchronized List<Column> getColumnsInternal() {
        List columnsInternal = super.getColumnsInternal();
        if (columnsInternal.isEmpty() && this._dataContext != null) {
            try (org.apache.hadoop.hbase.client.Table table = this._dataContext.getHTable(this.getName());){
                this.addColumn("_id", this._defaultRowKeyColumnType, 1);
                HColumnDescriptor[] columnFamilies = table.getTableDescriptor().getColumnFamilies();
                for (int i = 0; i < columnFamilies.length; ++i) {
                    this.addColumn(columnFamilies[i].getNameAsString(), HBaseColumn.DEFAULT_COLUMN_TYPE_FOR_COLUMN_FAMILIES, i + 2);
                }
            }
            catch (Exception e) {
                throw new MetaModelException("Could not resolve table ", e);
            }
        }
        return columnsInternal;
    }

    Set<String> getColumnFamilies() {
        return this.getColumnsInternal().stream().map(column -> (HBaseColumn)((Object)column)).map(HBaseColumn::getColumnFamily).distinct().collect(Collectors.toSet());
    }
}

