/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.metamodel.util.AbstractDirectoryInputStream;
import org.apache.metamodel.util.FileHelper;

class HdfsDirectoryInputStream
extends AbstractDirectoryInputStream<FileStatus> {
    private final Path _hadoopPath;
    private final FileSystem _fs;

    public HdfsDirectoryInputStream(Path hadoopPath, FileSystem fs) {
        Object[] fileStatuses;
        this._hadoopPath = hadoopPath;
        this._fs = fs;
        try {
            fileStatuses = this._fs.listStatus(this._hadoopPath, new PathFilter(){

                public boolean accept(Path path) {
                    try {
                        return HdfsDirectoryInputStream.this._fs.isFile(path);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            });
            Arrays.sort(fileStatuses);
        }
        catch (IOException e) {
            fileStatuses = new FileStatus[]{};
        }
        this._files = fileStatuses;
    }

    public InputStream openStream(int index) throws IOException {
        Path nextPath = ((FileStatus[])this._files)[index].getPath();
        return this._fs.open(nextPath);
    }

    public void close() throws IOException {
        super.close();
        FileHelper.safeClose((Object[])new Object[]{this._fs});
    }
}

