/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.excel.SpreadsheetReaderDelegate;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSpreadsheetReaderDelegate
implements SpreadsheetReaderDelegate {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpreadsheetReaderDelegate.class);
    private final Resource _resource;
    private final ExcelConfiguration _configuration;

    public DefaultSpreadsheetReaderDelegate(Resource resource, ExcelConfiguration configuration) {
        this._resource = resource;
        this._configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(String schemaName) {
        MutableSchema mutableSchema;
        MutableSchema schema = new MutableSchema(schemaName);
        Workbook wb = ExcelUtils.readWorkbook(this._resource);
        try {
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                Sheet currentSheet = wb.getSheetAt(i);
                MutableTable table = this.createTable(wb, currentSheet);
                table.setSchema((Schema)schema);
                schema.addTable((Table)table);
            }
            mutableSchema = schema;
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{wb});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{wb});
        return mutableSchema;
    }

    @Override
    public DataSet executeQuery(Table table, List<Column> columns, int maxRows) {
        Workbook wb = ExcelUtils.readWorkbook(this._resource);
        Sheet sheet = wb.getSheet(table.getName());
        if (sheet == null || sheet.getPhysicalNumberOfRows() == 0) {
            return new EmptyDataSet(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        }
        DataSet dataSet = ExcelUtils.getDataSet(wb, sheet, table, this._configuration);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    @Override
    public void notifyTablesModified() {
    }

    private MutableTable createTable(Workbook wb, Sheet sheet) {
        int columnNameLineNumber;
        MutableTable table = new MutableTable(sheet.getSheetName(), TableType.TABLE);
        if (sheet.getPhysicalNumberOfRows() <= 0) {
            return table;
        }
        Iterator<Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._configuration, false);
        if (!rowIterator.hasNext()) {
            return table;
        }
        Row row = null;
        if (this._configuration.isSkipEmptyLines()) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
        } else {
            row = rowIterator.next();
        }
        if ((columnNameLineNumber = this._configuration.getColumnNameLineNumber()) == 0) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
            ColumnNamingStrategy columnNamingStrategy = this._configuration.getColumnNamingStrategy();
            try (ColumnNamingSession columnNamingSession = columnNamingStrategy.startColumnNamingSession();){
                int offset = this.getColumnOffset(row);
                for (int i = 0; i < offset; ++i) {
                    columnNamingSession.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl(i));
                }
                for (int j = offset; j < row.getLastCellNum(); ++j) {
                    ColumnNamingContextImpl namingContext = new ColumnNamingContextImpl((Table)table, null, j);
                    MutableColumn column = new MutableColumn(columnNamingSession.getNextColumnName((ColumnNamingContext)namingContext), ColumnType.STRING, (Table)table, j, Boolean.valueOf(true));
                    table.addColumn((Column)column);
                }
            }
        } else {
            boolean hasColumns = true;
            for (int j = 1; j < columnNameLineNumber; ++j) {
                if (!rowIterator.hasNext()) {
                    hasColumns = false;
                    break;
                }
                row = rowIterator.next();
            }
            if (hasColumns) {
                this.createColumns(table, wb, row);
            }
        }
        return table;
    }

    private void createColumns(MutableTable table, Workbook wb, Row row) {
        if (row == null) {
            logger.warn("Cannot create columns based on null row!");
            return;
        }
        short rowLength = row.getLastCellNum();
        int offset = this.getColumnOffset(row);
        try (ColumnNamingSession columnNamingSession = this._configuration.getColumnNamingStrategy().startColumnNamingSession();){
            for (int j = offset; j < rowLength; ++j) {
                Cell cell = row.getCell(j);
                String intrinsicColumnName = ExcelUtils.getCellValue(wb, cell);
                ColumnNamingContextImpl columnNamingContext = new ColumnNamingContextImpl((Table)table, intrinsicColumnName, j);
                String columnName = columnNamingSession.getNextColumnName((ColumnNamingContext)columnNamingContext);
                MutableColumn column = new MutableColumn(columnName, ColumnType.VARCHAR, (Table)table, j, Boolean.valueOf(true));
                table.addColumn((Column)column);
            }
        }
    }

    private int getColumnOffset(Row row) {
        short offset = this._configuration.isSkipEmptyColumns() ? row.getFirstCellNum() : (short)0;
        return offset;
    }
}

