/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.util.Map;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.TableType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class XlsxWorkbookToTablesHandler
extends DefaultHandler {
    private final MutableSchema _schema;
    private final Map<String, String> _tableNamesToRelationshipIds;

    public XlsxWorkbookToTablesHandler(MutableSchema schema, Map<String, String> tableNamesToRelationshipIds) {
        this._schema = schema;
        this._tableNamesToRelationshipIds = tableNamesToRelationshipIds;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("sheet".equals(qName)) {
            String name = attributes.getValue("name");
            assert (name != null);
            String relationId = attributes.getValue("r:id");
            assert (relationId != null);
            if (this._schema != null) {
                MutableTable table = new MutableTable(name, TableType.TABLE, (Schema)this._schema);
                this._schema.addTable(table);
            }
            this._tableNamesToRelationshipIds.put(name, relationId);
        }
    }
}

