/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.providers.http.ConfigurationUtils;
import org.apache.maven.wagon.providers.http.HttpConfiguration;
import org.apache.maven.wagon.providers.http.HttpMethodConfiguration;
import org.apache.maven.wagon.providers.http.RelaxedTrustStrategy;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.EncodingUtil;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final boolean PERSISTENT_POOL = Boolean.valueOf(System.getProperty("maven.wagon.http.pool", "true"));
    private static final boolean SSL_INSECURE = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.insecure", "false"));
    private static final boolean IGNORE_SSL_VALIDITY_DATES = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.ignore.validity.dates", "false"));
    private static final boolean SSL_ALLOW_ALL = Boolean.valueOf(System.getProperty("maven.wagon.http.ssl.allowall", "false"));
    private static final int MAX_CONN_PER_ROUTE = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxPerRoute", "20"));
    private static final int MAX_CONN_TOTAL = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxTotal", "40"));
    private static final PoolingHttpClientConnectionManager CONN_MAN = AbstractHttpClientWagon.createConnManager();
    protected static final int SC_TOO_MANY_REQUESTS = 429;
    private int initialBackoffSeconds = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.backoffSeconds", "5"));
    private static final int maxBackoffWaitSeconds = Integer.parseInt(System.getProperty("maven.wagon.httpconnectionManager.maxBackoffSeconds", "180"));
    private static CloseableHttpClient CLIENT = AbstractHttpClientWagon.createClient();
    private static String DEFAULT_USER_AGENT = AbstractHttpClientWagon.getDefaultUserAgent();
    private CredentialsProvider credentialsProvider;
    private AuthCache authCache;
    private HttpClientContext localContext;
    private Closeable closeable;
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;

    protected int backoff(int wait, String url) throws InterruptedException, TransferFailedException {
        TimeUnit.SECONDS.sleep(wait);
        int nextWait = wait * 2;
        if (nextWait >= AbstractHttpClientWagon.getMaxBackoffWaitSeconds()) {
            throw new TransferFailedException("Waited too long to access: " + url + ". Return code is: " + 429);
        }
        return nextWait;
    }

    private static PoolingHttpClientConnectionManager createConnManager() {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        String[] cipherSuites;
        String sslProtocolsStr = System.getProperty("https.protocols");
        String cipherSuitesStr = System.getProperty("https.cipherSuites");
        String[] sslProtocols = sslProtocolsStr != null ? sslProtocolsStr.split(" *, *") : null;
        String[] stringArray = cipherSuites = cipherSuitesStr != null ? cipherSuitesStr.split(" *, *") : null;
        if (SSL_INSECURE) {
            try {
                SSLContext sslContext = new SSLContextBuilder().useSSL().loadTrustMaterial(null, (TrustStrategy)new RelaxedTrustStrategy(IGNORE_SSL_VALIDITY_DATES)).build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, sslProtocols, cipherSuites, SSL_ALLOW_ALL ? SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new SSLInitializationException(ex.getMessage(), (Throwable)ex);
            }
        } else {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), sslProtocols, cipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        if (PERSISTENT_POOL) {
            connManager.setDefaultMaxPerRoute(MAX_CONN_PER_ROUTE);
            connManager.setMaxTotal(MAX_CONN_TOTAL);
        } else {
            connManager.setMaxTotal(1);
        }
        return connManager;
    }

    private static CloseableHttpClient createClient() {
        return HttpClientBuilder.create().useSystemProperties().disableConnectionState().setConnectionManager((HttpClientConnectionManager)CONN_MAN).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultUserAgent() {
        Properties props = new Properties();
        InputStream is = AbstractHttpClientWagon.class.getResourceAsStream("/META-INF/maven/org.apache.maven.wagon/wagon-http/pom.properties");
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ignore) {
            }
            finally {
                IOUtil.close((InputStream)is);
            }
        }
        String ver = props.getProperty("version", "unknown-version");
        return "Apache-Maven-Wagon/" + ver + " (Java " + System.getProperty("java.version") + "; ";
    }

    public void openConnectionInternal() {
        ProxyInfo proxyInfo;
        this.repository.setUrl(this.getURL(this.repository));
        this.localContext = HttpClientContext.create();
        this.credentialsProvider = new BasicCredentialsProvider();
        this.authCache = new BasicAuthCache();
        this.localContext.setCredentialsProvider(this.credentialsProvider);
        this.localContext.setAuthCache(this.authCache);
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                String host = this.getRepository().getHost();
                int port = this.getRepository().getPort() > -1 ? this.getRepository().getPort() : -1;
                this.credentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)creds);
            }
        }
        if ((proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost())) != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
                Object creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                int port = proxyInfo.getPort() > -1 ? proxyInfo.getPort() : -1;
                AuthScope authScope = new AuthScope(proxyHost, port);
                this.credentialsProvider.setCredentials(authScope, (Credentials)creds);
            }
        }
    }

    public void closeConnection() {
        if (!PERSISTENT_POOL) {
            CONN_MAN.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, (HttpEntity)new RequestEntityImplementation(stream, resource, (Wagon)this, source));
    }

    private void put(Resource resource, File source, HttpEntity httpEntity) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, httpEntity, this.buildUrl(resource));
    }

    private String buildUrl(Resource resource) {
        return EncodingUtil.encodeURLToString((String)this.getRepository().getUrl(), (String[])new String[]{resource.getName()});
    }

    private void put(Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(this.getInitialBackoffSeconds(), resource, source, httpEntity, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(int wait, Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            this.mkdirs(PathUtils.dirname((String)resource.getName()));
        }
        catch (HttpException he) {
            this.fireTransferError(resource, (Exception)((Object)he), 5);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
        }
        Repository repo = this.getRepository();
        HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
        AuthScope targetScope = new AuthScope(targetHost);
        if (this.credentialsProvider.getCredentials(targetScope) != null) {
            BasicScheme targetAuth = new BasicScheme();
            try {
                targetAuth.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC preemptive"));
                this.authCache.put(targetHost, (AuthScheme)targetAuth);
            }
            catch (MalformedChallengeException ignore) {
                // empty catch block
            }
        }
        HttpPut putMethod = new HttpPut(url);
        this.firePutStarted(resource, source);
        try {
            putMethod.setEntity(httpEntity);
            CloseableHttpResponse response = this.execute((HttpUriRequest)putMethod);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                String reasonPhrase = ", ReasonPhrase: " + response.getStatusLine().getReasonPhrase() + ".";
                this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
                switch (statusCode) {
                    case 200: 
                    case 201: 
                    case 202: 
                    case 204: {
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        this.put(resource, source, httpEntity, this.calculateRelocatedUrl((HttpResponse)response));
                        return;
                    }
                    case 403: {
                        this.fireSessionConnectionRefused();
                        throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                    }
                    case 404: {
                        throw new ResourceDoesNotExistException("File: " + url + " does not exist" + reasonPhrase);
                    }
                    case 429: {
                        this.put(this.backoff(wait, url), resource, source, httpEntity, url);
                        break;
                    }
                    default: {
                        TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
                        this.fireTransferError(resource, (Exception)e, 6);
                        throw e;
                    }
                }
                this.firePutCompleted(resource, source);
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected String calculateRelocatedUrl(HttpResponse response) {
        Header locationHeader = response.getFirstHeader("Location");
        String locationField = locationHeader.getValue();
        return locationField.startsWith("http") ? locationField : this.getURL(this.getRepository()) + '/' + locationField;
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.resourceExists(this.getInitialBackoffSeconds(), resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resourceExists(int wait, String resourceName) throws TransferFailedException, AuthorizationException {
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resourceName;
        HttpHead headMethod = new HttpHead(url);
        try {
            CloseableHttpResponse response = this.execute((HttpUriRequest)headMethod);
            try {
                boolean result;
                int statusCode = response.getStatusLine().getStatusCode();
                String reasonPhrase = ", ReasonPhrase: " + response.getStatusLine().getReasonPhrase() + ".";
                switch (statusCode) {
                    case 200: {
                        result = true;
                        break;
                    }
                    case 304: {
                        result = true;
                        break;
                    }
                    case 403: {
                        throw new AuthorizationException("Access denied to: " + url + reasonPhrase);
                    }
                    case 401: {
                        throw new AuthorizationException("Not authorized " + reasonPhrase);
                    }
                    case 407: {
                        throw new AuthorizationException("Not authorized by proxy " + reasonPhrase);
                    }
                    case 404: {
                        result = false;
                        break;
                    }
                    case 429: {
                        boolean bl = this.resourceExists(this.backoff(wait, resourceName), resourceName);
                        return bl;
                    }
                    default: {
                        throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + reasonPhrase);
                    }
                }
                EntityUtils.consume((HttpEntity)response.getEntity());
                boolean bl = result;
                return bl;
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        HttpHost targetHost;
        AuthScope targetScope;
        HttpMethodConfiguration config;
        this.setHeaders(httpMethod);
        String userAgent = this.getUserAgent(httpMethod);
        if (userAgent != null) {
            httpMethod.setHeader("User-Agent", userAgent);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("compatibility");
        Repository repo = this.getRepository();
        ProxyInfo proxyInfo = this.getProxyInfo(repo.getProtocol(), repo.getHost());
        if (proxyInfo != null) {
            HttpHost proxy = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            requestConfigBuilder.setProxy(proxy);
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(httpMethod);
        if (config != null) {
            ConfigurationUtils.copyConfig(config, requestConfigBuilder);
        } else {
            requestConfigBuilder.setSocketTimeout(this.getReadTimeout());
        }
        this.localContext.setRequestConfig(requestConfigBuilder.build());
        if (config != null && config.isUsePreemptive() && this.credentialsProvider.getCredentials(targetScope = new AuthScope(targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol()))) != null) {
            BasicScheme targetAuth = new BasicScheme();
            targetAuth.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC preemptive"));
            this.authCache.put(targetHost, (AuthScheme)targetAuth);
        }
        if (proxyInfo != null && proxyInfo.getHost() != null) {
            HttpHost proxyHost = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            AuthScope proxyScope = new AuthScope(proxyHost);
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyUsername != null && proxyPassword != null) {
                Object creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                this.credentialsProvider.setCredentials(proxyScope, (Credentials)creds);
                BasicScheme proxyAuth = new BasicScheme();
                proxyAuth.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC preemptive"));
                this.authCache.put(proxyHost, (AuthScheme)proxyAuth);
            }
        }
        return CLIENT.execute(httpMethod, (HttpContext)this.localContext);
    }

    protected void setHeaders(HttpUriRequest method) {
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addHeader("Cache-control", "no-cache");
            method.addHeader("Cache-store", "no-store");
            method.addHeader("Pragma", "no-cache");
            method.addHeader("Expires", "0");
            method.addHeader("Accept-Encoding", "gzip");
            method.addHeader("User-Agent", DEFAULT_USER_AGENT);
        }
        if (this.httpHeaders != null) {
            for (Map.Entry<Object, Object> entry : this.httpHeaders.entrySet()) {
                method.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (Header header : headers) {
                method.addHeader(header);
            }
        }
    }

    protected String getUserAgent(HttpUriRequest method) {
        HttpMethodConfiguration config;
        String value;
        if (this.httpHeaders != null && (value = (String)this.httpHeaders.get("User-Agent")) != null) {
            return value;
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            return (String)config.getHeaders().get("User-Agent");
        }
        return null;
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fillInputData(this.getInitialBackoffSeconds(), inputData);
    }

    private void fillInputData(int wait, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String repositoryUrl = this.getRepository().getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + resource.getName();
        HttpGet getMethod = new HttpGet(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            BasicHeader hdr = new BasicHeader("If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
            getMethod.addHeader((Header)hdr);
        }
        try {
            HttpEntity entity;
            Date lastModified;
            Header lastModifiedHeader;
            CloseableHttpResponse response = this.execute((HttpUriRequest)getMethod);
            this.closeable = response;
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = ", ReasonPhrase:" + response.getStatusLine().getReasonPhrase() + ".";
            this.fireTransferDebug(url + " - Status code: " + statusCode + reasonPhrase);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 304: {
                    return;
                }
                case 403: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Access denied to: " + url + " " + reasonPhrase);
                }
                case 401: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Not authorized " + reasonPhrase);
                }
                case 407: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException("Not authorized by proxy " + reasonPhrase);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " " + reasonPhrase);
                }
                case 429: {
                    this.fillInputData(this.backoff(wait, url), inputData);
                    break;
                }
                default: {
                    this.cleanupGetTransfer(resource);
                    TransferFailedException e = new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode + " " + reasonPhrase);
                    this.fireTransferError(resource, (Exception)e, 5);
                    throw e;
                }
            }
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader != null) {
                try {
                    long contentLength = Long.parseLong(contentLengthHeader.getValue());
                    resource.setContentLength(contentLength);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
                }
            }
            if ((lastModifiedHeader = response.getFirstHeader("Last-Modified")) != null && (lastModified = DateUtils.parseDate((String)lastModifiedHeader.getValue())) != null) {
                resource.setLastModified(lastModified.getTime());
                this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified.getTime() + ")");
            }
            if ((entity = response.getEntity()) != null) {
                inputData.setInputStream(entity.getContent());
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected void cleanupGetTransfer(Resource resource) {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.putFromStream(stream, destination, -1L, -1L);
    }

    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.putFromStream(stream, resource.getName(), -1L, -1L);
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("this wagon http client must not use fillOutputData");
    }

    public int getInitialBackoffSeconds() {
        return this.initialBackoffSeconds;
    }

    public void setInitialBackoffSeconds(int initialBackoffSeconds) {
        this.initialBackoffSeconds = initialBackoffSeconds;
    }

    public static int getMaxBackoffWaitSeconds() {
        return maxBackoffWaitSeconds;
    }

    private final class RequestEntityImplementation
    extends AbstractHttpEntity {
        private static final int BUFFER_SIZE = 2048;
        private final Resource resource;
        private final Wagon wagon;
        private ByteBuffer byteBuffer;
        private File source;
        private long length = -1L;

        private RequestEntityImplementation(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
            } else {
                try {
                    byte[] bytes = IOUtil.toByteArray((InputStream)stream);
                    this.byteBuffer = ByteBuffer.allocate(bytes.length);
                    this.byteBuffer.put(bytes);
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
            }
            this.resource = resource;
            this.length = resource == null ? -1L : resource.getContentLength();
            this.wagon = wagon;
        }

        public long getContentLength() {
            return this.length;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            if (this.source != null) {
                return new FileInputStream(this.source);
            }
            return new ByteArrayInputStream(this.byteBuffer.array());
        }

        public boolean isRepeatable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outstream) throws IOException {
            block8: {
                if (outstream == null) {
                    throw new IllegalArgumentException("Output stream may not be null");
                }
                TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
                transferEvent.setTimestamp(System.currentTimeMillis());
                InputStream instream = this.source != null ? new FileInputStream(this.source) : new ByteArrayInputStream(this.byteBuffer.array());
                try {
                    int l;
                    byte[] buffer = new byte[2048];
                    if (this.length < 0L) {
                        int l2;
                        while ((l2 = instream.read(buffer)) != -1) {
                            AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, -1);
                            outstream.write(buffer, 0, l2);
                        }
                        break block8;
                    }
                    for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                        l = instream.read(buffer, 0, (int)Math.min(2048L, remaining));
                        if (l == -1) {
                            break;
                        }
                        AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer, (int)Math.min(2048L, remaining));
                        outstream.write(buffer, 0, l);
                    }
                }
                finally {
                    instream.close();
                }
            }
        }

        public boolean isStreaming() {
            return true;
        }
    }
}

