/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetStatistics;
import org.apache.maven.surefire.util.internal.StringUtils;

public class RunStatistics
extends TestSetStatistics {
    private final Sources errorSources = new Sources();
    private final Sources failureSources = new Sources();

    public void addErrorSource(String errorSource) {
        this.errorSources.addSource(errorSource);
    }

    public void addErrorSource(String errorSource, StackTraceWriter stackTraceWriter) {
        this.errorSources.addSource(errorSource, stackTraceWriter);
    }

    public void addFailureSource(String failureSource) {
        this.failureSources.addSource(failureSource);
    }

    public void addFailureSource(String failureSource, StackTraceWriter stackTraceWriter) {
        this.failureSources.addSource(failureSource, stackTraceWriter);
    }

    public Collection getErrorSources() {
        return this.errorSources.getListOfSources();
    }

    public Collection getFailureSources() {
        return this.failureSources.getListOfSources();
    }

    private static class Sources {
        private final Collection listOfSources = new ArrayList();

        private Sources() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSource(String source) {
            Collection collection = this.listOfSources;
            synchronized (collection) {
                this.listOfSources.add(source);
            }
        }

        void addSource(String source, StackTraceWriter stackTraceWriter) {
            String message = this.getMessageOfThrowable(stackTraceWriter);
            String extendedSource = StringUtils.isBlank(message) ? source : source + ": " + this.trimToSingleLine(message);
            this.addSource(extendedSource);
        }

        private String trimToSingleLine(String str) {
            int i = str.indexOf("\n");
            return i >= 0 ? str.substring(0, i) : str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection getListOfSources() {
            Collection collection = this.listOfSources;
            synchronized (collection) {
                return Collections.unmodifiableCollection(this.listOfSources);
            }
        }

        private String getMessageOfThrowable(StackTraceWriter stackTraceWriter) {
            return stackTraceWriter != null ? this.getMessageOfThrowable(stackTraceWriter.getThrowable()) : "";
        }

        private String getMessageOfThrowable(Throwable throwable) {
            return throwable != null ? throwable.getLocalizedMessage() : "";
        }
    }
}

