/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.util.internal.ImmutableMap;

public class SimpleReportEntry
implements TestSetReportEntry {
    private final Map<String, String> systemProperties;
    private final String source;
    private final String name;
    private final StackTraceWriter stackTraceWriter;
    private final Integer elapsed;
    private final String message;

    public SimpleReportEntry() {
        this(null, null);
    }

    public SimpleReportEntry(String source, String name) {
        this(source, name, null, null);
    }

    public SimpleReportEntry(String source, String name, Map<String, String> systemProperties) {
        this(source, name, null, null, systemProperties);
    }

    private SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter) {
        this(source, name, stackTraceWriter, null);
    }

    public SimpleReportEntry(String source, String name, Integer elapsed) {
        this(source, name, null, elapsed);
    }

    public SimpleReportEntry(String source, String name, String message) {
        this(source, name, null, null, message, Collections.emptyMap());
    }

    protected SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter, Integer elapsed, String message, Map<String, String> systemProperties) {
        if (source == null) {
            source = "null";
        }
        if (name == null) {
            name = "null";
        }
        this.source = source;
        this.name = name;
        this.stackTraceWriter = stackTraceWriter;
        this.message = message;
        this.elapsed = elapsed;
        this.systemProperties = new ImmutableMap<String, String>(systemProperties);
    }

    public SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter, Integer elapsed) {
        this(source, name, stackTraceWriter, elapsed, Collections.emptyMap());
    }

    public SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter, Integer elapsed, Map<String, String> systemProperties) {
        this(source, name, stackTraceWriter, elapsed, SimpleReportEntry.safeGetMessage(stackTraceWriter), systemProperties);
    }

    public static SimpleReportEntry assumption(String source, String name, String message) {
        return new SimpleReportEntry(source, name, message);
    }

    public static SimpleReportEntry ignored(String source, String name, String message) {
        return new SimpleReportEntry(source, name, message);
    }

    public static SimpleReportEntry withException(String source, String name, StackTraceWriter stackTraceWriter) {
        return new SimpleReportEntry(source, name, stackTraceWriter);
    }

    private static String safeGetMessage(StackTraceWriter stackTraceWriter) {
        try {
            SafeThrowable t = stackTraceWriter == null ? null : stackTraceWriter.getThrowable();
            return t == null ? null : t.getMessage();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    @Override
    public String getSourceName() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    @Override
    public Integer getElapsed() {
        return this.elapsed;
    }

    public String toString() {
        return "ReportEntry{source='" + this.source + '\'' + ", name='" + this.name + '\'' + ", stackTraceWriter=" + this.stackTraceWriter + ", elapsed=" + this.elapsed + ",message=" + this.message + '}';
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleReportEntry that = (SimpleReportEntry)o;
        return this.isElapsedTimeEqual(that) && this.isNameEqual(that) && this.isSourceEqual(that) && this.isStackEqual(that);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.stackTraceWriter != null ? this.stackTraceWriter.hashCode() : 0);
        result = 31 * result + (this.elapsed != null ? this.elapsed.hashCode() : 0);
        return result;
    }

    @Override
    public String getNameWithGroup() {
        return this.getName();
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    private boolean isElapsedTimeEqual(SimpleReportEntry en) {
        return this.elapsed != null ? this.elapsed.equals(en.elapsed) : en.elapsed == null;
    }

    private boolean isNameEqual(SimpleReportEntry en) {
        return this.name != null ? this.name.equals(en.name) : en.name == null;
    }

    private boolean isSourceEqual(SimpleReportEntry en) {
        return this.source != null ? this.source.equals(en.source) : en.source == null;
    }

    private boolean isStackEqual(SimpleReportEntry en) {
        return this.stackTraceWriter != null ? this.stackTraceWriter.equals(en.stackTraceWriter) : en.stackTraceWriter == null;
    }
}

