/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.surefire.api.util.internal.ImmutableMap;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.CommandReader;

public class StreamFeeder
extends CloseableDaemonThread {
    private static final Map<MasterProcessCommand, String> COMMAND_OPCODES = StreamFeeder.opcodesToStrings();
    private final WritableByteChannel channel;
    private final CommandReader commandReader;
    private final ConsoleLogger logger;
    private volatile boolean disabled;
    private volatile Throwable exception;

    public StreamFeeder(@Nonnull String threadName, @Nonnull WritableByteChannel channel, @Nonnull CommandReader commandReader, @Nonnull ConsoleLogger logger) {
        super(threadName);
        this.channel = channel;
        this.commandReader = commandReader;
        this.logger = logger;
    }

    public void run() {
        try (WritableByteChannel c2 = this.channel;){
            Command cmd;
            while ((cmd = this.commandReader.readNextCommand()) != null) {
                if (this.disabled) continue;
                MasterProcessCommand cmdType = cmd.getCommandType();
                byte[] data = cmdType.hasDataType() ? StreamFeeder.encode(cmdType, cmd.getData()) : StreamFeeder.encode(cmdType);
                c2.write(ByteBuffer.wrap(data));
            }
        }
        catch (ClosedChannelException c2) {
        }
        catch (IOException | NonWritableChannelException e) {
            this.exception = e.getCause() == null ? e : e.getCause();
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void disable() {
        this.disabled = true;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public static byte[] encode(MasterProcessCommand cmdType, String data) {
        if (!cmdType.hasDataType()) {
            throw new IllegalArgumentException("cannot use data without data type");
        }
        if (cmdType.getDataType() != String.class) {
            throw new IllegalArgumentException("Data type can be only " + String.class);
        }
        return StreamFeeder.encode(COMMAND_OPCODES.get(cmdType), data).toString().getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encode(MasterProcessCommand cmdType) {
        if (cmdType.getDataType() != Void.class) {
            throw new IllegalArgumentException("Data type can be only " + cmdType.getDataType());
        }
        return StreamFeeder.encode(COMMAND_OPCODES.get(cmdType), null).toString().getBytes(StandardCharsets.US_ASCII);
    }

    private static StringBuilder encode(String operation, String data) {
        StringBuilder s = new StringBuilder(128).append(':').append("maven-surefire-command").append(':').append(operation);
        if (data != null) {
            s.append(':').append(data);
        }
        return s.append(':');
    }

    private static Map<MasterProcessCommand, String> opcodesToStrings() {
        HashMap<MasterProcessCommand, String> opcodes = new HashMap<MasterProcessCommand, String>();
        opcodes.put(MasterProcessCommand.RUN_CLASS, "run-testclass");
        opcodes.put(MasterProcessCommand.TEST_SET_FINISHED, "testset-finished");
        opcodes.put(MasterProcessCommand.SKIP_SINCE_NEXT_TEST, "skip-since-next-test");
        opcodes.put(MasterProcessCommand.SHUTDOWN, "shutdown");
        opcodes.put(MasterProcessCommand.NOOP, "noop");
        opcodes.put(MasterProcessCommand.BYE_ACK, "bye-ack");
        return new ImmutableMap(opcodes);
    }
}

