/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkingStreamConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.FileOutputConsumerProxy;
import org.apache.maven.plugin.surefire.booterclient.output.OutputConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.StandardOutputConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.SupressFooterOutputConsumerProxy;
import org.apache.maven.plugin.surefire.booterclient.output.SupressHeaderOutputConsumerProxy;
import org.apache.maven.plugin.surefire.booterclient.output.SynchronizedOutputConsumer;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireStarter;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkStarter {
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final File reportsDirectory;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, File reportsDirectory, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.reportsDirectory = reportsDirectory;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
    }

    public int run() throws SurefireBooterForkException, SurefireExecutionException {
        int result;
        String requestedForkMode = this.forkConfiguration.getForkMode();
        if ("never".equals(requestedForkMode)) {
            SurefireStarter surefireStarter = new SurefireStarter(this.startupConfiguration, this.providerConfiguration);
            RunResult runResult = surefireStarter.runSuitesInProcess();
            result = surefireStarter.processRunCount(runResult);
        } else if ("once".equals(requestedForkMode)) {
            result = this.runSuitesForkOnce();
        } else if ("always".equals(requestedForkMode)) {
            result = this.runSuitesForkPerTestSet();
        } else {
            throw new SurefireExecutionException("Unknown forkmode: " + requestedForkMode, null);
        }
        return result;
    }

    private int runSuitesForkOnce() throws SurefireBooterForkException {
        return this.fork(null, this.providerConfiguration.getProviderProperties(), true, true);
    }

    private int runSuitesForkPerTestSet() throws SurefireBooterForkException {
        ClassLoader surefireClassLoader;
        ClassLoader testsClassLoader;
        int globalResult = 0;
        try {
            testsClassLoader = this.startupConfiguration.getClasspathConfiguration().createTestClassLoader(false);
            surefireClassLoader = this.startupConfiguration.getClasspathConfiguration().createSurefireClassLoader(testsClassLoader);
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
        boolean showHeading = true;
        ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader);
        SurefireProvider surefireProvider = providerFactory.createProvider(testsClassLoader);
        Properties properties = new Properties();
        Iterator suites = surefireProvider.getSuites();
        while (suites.hasNext()) {
            boolean showFooter;
            Object testSet = suites.next();
            int result = this.fork(testSet, properties, showHeading, showFooter = !suites.hasNext());
            if (result > globalResult) {
                globalResult = result;
            }
            showHeading = false;
        }
        return globalResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fork(Object testSet, Properties properties, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        int returnCode;
        ForkingStreamConsumer err;
        File surefireProperties;
        File systemProperties = null;
        try {
            BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration, properties);
            surefireProperties = booterSerializer.serialize(this.providerConfiguration, this.startupConfiguration, testSet);
            if (this.forkConfiguration.getSystemProperties() != null) {
                systemProperties = SystemPropertyManager.writePropertiesFile((Properties)this.forkConfiguration.getSystemProperties(), (File)this.forkConfiguration.getTempDirectory(), (String)"surefire", (boolean)this.forkConfiguration.isDebug());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
        }
        Classpath bootClasspathConfiguration = this.forkConfiguration.getBootClasspath();
        Classpath additionlClassPathUrls = this.startupConfiguration.useSystemClassLoader() ? this.startupConfiguration.getClasspathConfiguration().getTestClasspath() : null;
        Classpath bootClasspath = bootClasspathConfiguration.append(additionlClassPathUrls);
        Commandline cli = this.forkConfiguration.createCommandLine(bootClasspath.getClassPath(), this.startupConfiguration.getClassLoaderConfiguration());
        cli.createArg().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        boolean willBeSharingConsumer = this.startupConfiguration.isRedirectTestOutputToFile();
        ForkingStreamConsumer out = this.getForkingStreamConsumer(showHeading, showFooter, this.startupConfiguration.isRedirectTestOutputToFile(), willBeSharingConsumer);
        ForkingStreamConsumer forkingStreamConsumer = err = willBeSharingConsumer ? out : this.getForkingStreamConsumer(showHeading, showFooter, this.startupConfiguration.isRedirectTestOutputToFile(), false);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this.forkedProcessTimeoutInSeconds);
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e.getCause());
        }
        if (this.startupConfiguration.isRedirectTestOutputToFile()) {
            try {
                out.getOutputConsumer().testSetCompleted();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (surefireProperties == null) return returnCode;
        if (!surefireProperties.exists()) return returnCode;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(surefireProperties);
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new SurefireBooterForkException("Unable to reload properties file from forked process", (Throwable)e);
                catch (IOException e2) {
                    throw new SurefireBooterForkException("Unable to reload properties file from forked process", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inStream);
        return returnCode;
    }

    private ForkingStreamConsumer getForkingStreamConsumer(boolean showHeading, boolean showFooter, boolean redirectTestOutputToFile, boolean mustBeThreadSafe) {
        OutputConsumer outputConsumer = new StandardOutputConsumer();
        if (redirectTestOutputToFile) {
            outputConsumer = new FileOutputConsumerProxy(outputConsumer, this.reportsDirectory);
        }
        if (!showHeading) {
            outputConsumer = new SupressHeaderOutputConsumerProxy(outputConsumer);
        }
        if (!showFooter) {
            outputConsumer = new SupressFooterOutputConsumerProxy(outputConsumer);
        }
        if (mustBeThreadSafe) {
            outputConsumer = new SynchronizedOutputConsumer(outputConsumer);
        }
        return new ForkingStreamConsumer(outputConsumer);
    }
}

