/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.classes.JarVersionedRuntimes;
import org.apache.maven.shared.jar.identification.JarIdentification;

public final class JarData {
    private static final Attributes.Name ATTR_MULTI_RELEASE = new Attributes.Name("Multi-Release");
    private final File file;
    private final boolean aSealed;
    private boolean multiRelease;
    private String fileHash;
    private String bytecodeHash;
    private final Manifest manifest;
    private JarClasses jarClasses;
    private final List<JarEntry> entries;
    private JarIdentification jarIdentification;
    private JarVersionedRuntimes versionedRuntimes;

    public JarData(File file, Manifest manifest, List<JarEntry> entries) {
        this.file = file;
        this.manifest = manifest;
        this.entries = Collections.unmodifiableList(entries);
        this.aSealed = this.isAttributePresent(Attributes.Name.SEALED);
        this.multiRelease = this.isAttributePresent(ATTR_MULTI_RELEASE);
    }

    public List<JarEntry> getEntries() {
        return this.entries;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isSealed() {
        return this.aSealed;
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }

    public void setFileHash(String fileHash) {
        this.fileHash = fileHash;
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public void setBytecodeHash(String bytecodeHash) {
        this.bytecodeHash = bytecodeHash;
    }

    public String getBytecodeHash() {
        return this.bytecodeHash;
    }

    public boolean isDebugPresent() {
        return this.jarClasses.isDebugPresent();
    }

    public void setJarClasses(JarClasses jarClasses) {
        this.jarClasses = jarClasses;
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public int getNumClasses() {
        return this.jarClasses.getClassNames().size();
    }

    public int getNumPackages() {
        return this.jarClasses.getPackages().size();
    }

    public String getJdkRevision() {
        return this.jarClasses.getJdkRevision();
    }

    public void setJarIdentification(JarIdentification jarIdentification) {
        this.jarIdentification = jarIdentification;
    }

    public JarIdentification getJarIdentification() {
        return this.jarIdentification;
    }

    public JarClasses getJarClasses() {
        return this.jarClasses;
    }

    public void setVersionedRuntimes(JarVersionedRuntimes versionedRuntimess) {
        this.versionedRuntimes = versionedRuntimess;
    }

    public JarVersionedRuntimes getVersionedRuntimes() {
        return this.versionedRuntimes;
    }

    private boolean isAttributePresent(Attributes.Name attrName) {
        if (this.manifest != null) {
            String sval = this.manifest.getMainAttributes().getValue(attrName);
            return sval != null && "true".equalsIgnoreCase(sval.trim());
        }
        return false;
    }
}

