/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ProjectDependencyAnalysis {
    private final Set usedDeclaredArtifacts;
    private final Set usedUndeclaredArtifacts;
    private final Set unusedDeclaredArtifacts;

    public ProjectDependencyAnalysis() {
        this(null, null, null);
    }

    public ProjectDependencyAnalysis(Set usedDeclaredArtifacts, Set usedUndeclaredArtifacts, Set unusedDeclaredArtifacts) {
        this.usedDeclaredArtifacts = this.safeCopy(usedDeclaredArtifacts);
        this.usedUndeclaredArtifacts = this.safeCopy(usedUndeclaredArtifacts);
        this.unusedDeclaredArtifacts = this.safeCopy(unusedDeclaredArtifacts);
    }

    public Set getUsedDeclaredArtifacts() {
        return this.usedDeclaredArtifacts;
    }

    public Set getUsedUndeclaredArtifacts() {
        return this.usedUndeclaredArtifacts;
    }

    public Set getUnusedDeclaredArtifacts() {
        return this.unusedDeclaredArtifacts;
    }

    public int hashCode() {
        int hashCode = ((Object)this.getUsedDeclaredArtifacts()).hashCode();
        hashCode = hashCode * 37 + ((Object)this.getUsedUndeclaredArtifacts()).hashCode();
        hashCode = hashCode * 37 + ((Object)this.getUnusedDeclaredArtifacts()).hashCode();
        return hashCode;
    }

    public boolean equals(Object object) {
        boolean equals;
        if (object instanceof ProjectDependencyAnalysis) {
            ProjectDependencyAnalysis analysis = (ProjectDependencyAnalysis)object;
            equals = ((Object)this.getUsedDeclaredArtifacts()).equals(analysis.getUsedDeclaredArtifacts()) && ((Object)this.getUsedUndeclaredArtifacts()).equals(analysis.getUsedUndeclaredArtifacts()) && ((Object)this.getUnusedDeclaredArtifacts()).equals(analysis.getUnusedDeclaredArtifacts());
        } else {
            equals = false;
        }
        return equals;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!this.getUsedDeclaredArtifacts().isEmpty()) {
            buffer.append("usedDeclaredArtifacts=").append(this.getUsedDeclaredArtifacts());
        }
        if (!this.getUsedUndeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("usedUndeclaredArtifacts=").append(this.getUsedUndeclaredArtifacts());
        }
        if (!this.getUnusedDeclaredArtifacts().isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append("unusedDeclaredArtifacts=").append(this.getUnusedDeclaredArtifacts());
        }
        buffer.insert(0, "[");
        buffer.insert(0, this.getClass().getName());
        buffer.append("]");
        return buffer.toString();
    }

    private Set safeCopy(Set set) {
        return set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new LinkedHashSet(set));
    }
}

