/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.update;

import java.io.File;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.changelog.SvnChangeLogCommand;
import org.apache.maven.scm.provider.svn.svnexe.command.update.SvnUpdateConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnUpdateCommand
extends AbstractUpdateCommand
implements SvnCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        int exitCode;
        Commandline cl = SvnUpdateCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), version);
        SvnUpdateConsumer consumer = new SvnUpdateConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new UpdateScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new UpdateScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), String.valueOf(consumer.getRevision()));
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        if (version != null && StringUtils.isEmpty((String)version.getName())) {
            version = null;
        }
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        if (version == null || SvnTagBranchUtils.isRevisionSpecifier((ScmVersion)version)) {
            cl.createArgument().setValue("update");
            if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
                cl.createArgument().setValue("-r");
                cl.createArgument().setValue(version.getName());
            }
        } else if (version instanceof ScmBranch) {
            cl.createArgument().setValue("switch");
            if (version instanceof ScmTag) {
                cl.createArgument().setValue(SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)((ScmTag)version)));
            } else {
                cl.createArgument().setValue(SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)((ScmBranch)version)));
            }
            cl.createArgument().setValue(workingDirectory.getAbsolutePath());
        }
        return cl;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        SvnChangeLogCommand command = new SvnChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

