/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.integrity.command.blame;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.integrity.command.blame.IntegrityBlameConsumer;
import org.apache.maven.scm.provider.integrity.repository.IntegrityScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class IntegrityBlameCommand
extends AbstractBlameCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repository, ScmFileSet workingDirectory, String filename) throws ScmException {
        this.getLogger().info("Attempting to display blame results for file: " + filename);
        if (null == filename || filename.length() == 0) {
            throw new ScmException("A single filename is required to execute the blame command!");
        }
        IntegrityScmProviderRepository iRepo = (IntegrityScmProviderRepository)repository;
        this.doShellConnect(iRepo, workingDirectory);
        BlameScmResult result = this.doShellAnnotate(iRepo, workingDirectory, filename);
        return result;
    }

    private void doShellConnect(IntegrityScmProviderRepository iRepo, ScmFileSet workingDirectory) throws ScmException {
        Commandline shell = new Commandline();
        shell.setWorkingDirectory(workingDirectory.getBasedir());
        shell.setExecutable("si");
        shell.createArg().setValue("connect");
        shell.createArg().setValue("--hostname=" + iRepo.getHost());
        shell.createArg().setValue("--port=" + iRepo.getPort());
        shell.createArg().setValue("--user=" + iRepo.getUser());
        shell.createArg().setValue("--batch");
        shell.createArg().setValue("--password=" + iRepo.getPassword());
        CommandLineUtils.StringStreamConsumer shellConsumer = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + CommandLineUtils.toString((String[])shell.getCommandline()));
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)shell, (StreamConsumer)shellConsumer, (StreamConsumer)shellConsumer);
            if (exitCode != 0) {
                throw new ScmException("Can't login to integrity. Message : " + shellConsumer.toString());
            }
        }
        catch (CommandLineException cle) {
            this.getLogger().error("Command Line Connect Exception: " + cle.getMessage());
            throw new ScmException("Can't login to integrity. Message : " + cle.getMessage());
        }
    }

    private BlameScmResult doShellAnnotate(IntegrityScmProviderRepository iRepo, ScmFileSet workingDirectory, String filename) {
        Commandline shell = new Commandline();
        shell.setWorkingDirectory(workingDirectory.getBasedir());
        shell.setExecutable("si");
        shell.createArg().setValue("annotate");
        shell.createArg().setValue("--hostname=" + iRepo.getHost());
        shell.createArg().setValue("--port=" + iRepo.getPort());
        shell.createArg().setValue("--user=" + iRepo.getUser());
        shell.createArg().setValue("--fields=date,revision,author");
        shell.createArg().setValue('\"' + filename + '\"');
        IntegrityBlameConsumer shellConsumer = new IntegrityBlameConsumer(this.getLogger());
        try {
            this.getLogger().debug("Executing: " + CommandLineUtils.toString((String[])shell.getCommandline()));
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)shell, (StreamConsumer)shellConsumer, (StreamConsumer)new CommandLineUtils.StringStreamConsumer());
            boolean success = exitCode == 0;
            ScmResult scmResult = new ScmResult(shell.getCommandline().toString(), "", "Exit Code: " + exitCode, success);
            return new BlameScmResult(shellConsumer.getBlameList(), scmResult);
        }
        catch (CommandLineException cle) {
            this.getLogger().error("Command Line Exception: " + cle.getMessage());
            BlameScmResult result = new BlameScmResult(shell.getCommandline().toString(), cle.getMessage(), "", false);
            return result;
        }
    }
}

