/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.artifact;

import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoredArtifact
extends DefaultArtifact {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoredArtifact.class);
    public static final String MSG_INTERRUPTED_WHILE_RETRIEVING_ARTIFACT_FILE = "Interrupted while retrieving artifact file";
    public static final String MSG_ERROR_RETRIEVING_ARTIFACT_FILE = "Error retrieving artifact file";
    private volatile Future<File> fileFuture;
    private Function<File, File> restoreToDiskConsumer;

    public RestoredArtifact(Artifact parent, Future<File> fileFuture, String type, String classifier, ArtifactHandler handler, Function<File, File> restoreToDiskConsumer) {
        super(parent.getGroupId(), parent.getArtifactId(), parent.getVersionRange(), parent.getScope(), type, classifier, handler, parent.isOptional());
        this.fileFuture = Objects.requireNonNull(fileFuture, "fileFuture == null");
        this.restoreToDiskConsumer = restoreToDiskConsumer;
    }

    public File getFile() {
        if (!this.fileFuture.isDone()) {
            if (this.fileFuture instanceof RunnableFuture) {
                try {
                    LOGGER.trace("Artifact file {} is not yet retrieved, downloading directly", (Object)this.getDependencyConflictId());
                    ((RunnableFuture)this.fileFuture).run();
                }
                catch (RuntimeException e) {
                    throw new InvalidArtifactRTException(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), MSG_ERROR_RETRIEVING_ARTIFACT_FILE, (Throwable)e);
                }
            } else {
                LOGGER.trace("Artifact file {} is not yet retrieved, waiting for download to complete", (Object)this.getDependencyConflictId());
            }
        }
        try {
            File file = this.fileFuture.get();
            return this.restoreToDiskConsumer.apply(file);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InvalidArtifactRTException(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), MSG_INTERRUPTED_WHILE_RETRIEVING_ARTIFACT_FILE, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new InvalidArtifactRTException(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), MSG_ERROR_RETRIEVING_ARTIFACT_FILE, e.getCause());
        }
    }

    public void setFile(File destination) {
        this.fileFuture = CompletableFuture.completedFuture(destination);
    }
}

