/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;

public class CachingDoubleValueSource
extends ValueSource {
    final ValueSource source;
    final Map<Integer, Double> cache;

    public CachingDoubleValueSource(ValueSource source) {
        this.source = source;
        this.cache = new HashMap<Integer, Double>();
    }

    public String description() {
        return "Cached[" + this.source.description() + "]";
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final int base = readerContext.docBase;
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new FunctionValues(){

            public double doubleVal(int doc) {
                Integer key = base + doc;
                Double v = CachingDoubleValueSource.this.cache.get(key);
                if (v == null) {
                    v = vals.doubleVal(doc);
                    CachingDoubleValueSource.this.cache.put(key, v);
                }
                return v;
            }

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public String toString(int doc) {
                return this.doubleVal(doc) + "";
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CachingDoubleValueSource that = (CachingDoubleValueSource)((Object)o);
        return !(this.source != null ? !this.source.equals((Object)that.source) : that.source != null);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }
}

