/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineMetaData$;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.exception.StorageFatalException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.resultset.ResultSetWriter$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StorageUtils$
implements Logging {
    public static final StorageUtils$ MODULE$;
    private final String HDFS;
    private final String FILE;
    private final String FILE_SCHEMA;
    private final String HDFS_SCHEMA;
    private final NumberFormat nf;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageUtils$();
    }

    private Logger logger$lzycompute() {
        StorageUtils$ storageUtils$ = this;
        synchronized (storageUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public String HDFS() {
        return this.HDFS;
    }

    public String FILE() {
        return this.FILE;
    }

    public String FILE_SCHEMA() {
        return this.FILE_SCHEMA;
    }

    public String HDFS_SCHEMA() {
        return this.HDFS_SCHEMA;
    }

    private NumberFormat nf() {
        return this.nf;
    }

    public String doubleToString(double value) {
        return this.nf().format(value);
    }

    public <T> Map<String, T> loadClass(String classStr, Function1<T, String> op) {
        String[] _classes = classStr.split(",");
        LinkedHashMap classes = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])_classes).foreach((Function1)new Serializable(op, classes){
            public static final long serialVersionUID = 0L;
            public final Function1 op$1;
            public final LinkedHashMap classes$1;

            public final LinkedHashMap<String, T> apply(String clazz) {
                return (LinkedHashMap)Utils$.MODULE$.tryAndError((Function0)new Serializable(this, clazz){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadClass.1 $outer;
                    private final String clazz$1;

                    public final LinkedHashMap<String, T> apply() {
                        Object obj = Utils$.MODULE$.getClassInstance(this.clazz$1.trim());
                        return this.$outer.classes$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.$outer.op$1.apply(obj)), obj));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.clazz$1 = clazz$1;
                    }
                }, StorageUtils$.MODULE$.logger());
            }
            {
                this.op$1 = op$1;
                this.classes$1 = classes$1;
            }
        });
        return classes.toMap(Predef$.MODULE$.$conforms());
    }

    public <T> Map<String, Class<T>> loadClasses(String classStr, String pge, Function1<Class<T>, String> op) {
        String[] _classes = StringUtils.isEmpty((String)pge) ? classStr.split(",") : (String[])Predef$.MODULE$.refArrayOps((Object[])classStr.split(",")).map((Function1)new Serializable(pge){
            public static final long serialVersionUID = 0L;
            private final String pge$1;

            public final String apply(String value) {
                return new StringBuilder().append((Object)this.pge$1).append((Object)".").append((Object)value).toString();
            }
            {
                this.pge$1 = pge$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        LinkedHashMap classes = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])_classes).foreach((Function1)new Serializable(op, classes){
            public static final long serialVersionUID = 0L;
            public final Function1 op$2;
            public final LinkedHashMap classes$2;

            public final LinkedHashMap<String, Class<T>> apply(String clazz) {
                return (LinkedHashMap)Utils$.MODULE$.tryAndError((Function0)new Serializable(this, clazz){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadClasses.1 $outer;
                    private final String clazz$2;

                    public final LinkedHashMap<String, Class<T>> apply() {
                        Class<?> _class = Thread.currentThread().getContextClassLoader().loadClass(this.clazz$2.trim());
                        return this.$outer.classes$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.$outer.op$2.apply(_class)), _class));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.clazz$2 = clazz$2;
                    }
                }, StorageUtils$.MODULE$.logger());
            }
            {
                this.op$2 = op$2;
                this.classes$2 = classes$2;
            }
        });
        return classes.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public String pathToSuffix(String path) {
        void var2_2;
        int dot;
        String fileName = new File(path).getName();
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return var2_2;
    }

    public Object invoke(Object obj, Method method, Object[] args) {
        return method.invoke(obj, new Object[]{args});
    }

    public String serializerStringToResult(String value) {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.TEXT_TYPE());
        ResultSetWriter<? extends MetaData, ? extends Record> writer = ResultSetWriter$.MODULE$.getResultSetWriter(resultSet, Long.MAX_VALUE, null);
        LineMetaData metaData = new LineMetaData(LineMetaData$.MODULE$.$lessinit$greater$default$1());
        LineRecord record = new LineRecord(value);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)record);
        String res = writer.toString();
        Utils$.MODULE$.tryQuietly((Function0)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final ResultSetWriter writer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        });
        return res;
    }

    public String deserializerResultToString(String result) {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.TEXT_TYPE());
        ResultSetReader<? extends MetaData, ? extends Record> reader = ResultSetReader$.MODULE$.getResultSetReader(resultSet, result);
        reader.getMetaData();
        StringBuilder sb = new StringBuilder();
        while (reader.hasNext()) {
            LineRecord record = (LineRecord)reader.getRecord();
            sb.append(record.getLine());
        }
        String value = sb.toString();
        Utils$.MODULE$.tryQuietly((Function0)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final ResultSetReader reader$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.reader$1.close();
            }
            {
                this.reader$1 = reader$1;
            }
        });
        return value;
    }

    public void close(OutputStream outputStream) {
        this.close(outputStream, null, null);
    }

    public void close(InputStream inputStream) {
        this.close(null, inputStream, null);
    }

    public void close(Fs fs) {
        this.close(null, null, fs);
    }

    public void close(OutputStream outputStream, InputStream inputStream, Fs fs) {
        Utils$.MODULE$.tryFinally((Function0)new Serializable(outputStream){
            public static final long serialVersionUID = 0L;
            private final OutputStream outputStream$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.outputStream$1 != null) {
                    this.outputStream$1.close();
                }
            }
            {
                this.outputStream$1 = outputStream$1;
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
        Utils$.MODULE$.tryFinally((Function0)new Serializable(inputStream){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.inputStream$1 != null) {
                    this.inputStream$1.close();
                }
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
        Utils$.MODULE$.tryFinally((Function0)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final Fs fs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.fs$1 != null) {
                    this.fs$1.close();
                }
            }
            {
                this.fs$1 = fs$1;
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
    }

    public void close(Closeable closeable) {
        Utils$.MODULE$.tryFinally((Function0)new Serializable(closeable){
            public static final long serialVersionUID = 0L;
            private final Closeable closeable$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.closeable$1 != null) {
                    this.closeable$1.close();
                }
            }
            {
                this.closeable$1 = closeable$1;
            }
        }, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
            }
        });
    }

    public String getJvmUser() {
        return System.getProperty("user.name");
    }

    public boolean isHDFSNode() {
        File confPath = new File(HadoopConf$.MODULE$.hadoopConfDir());
        if (confPath.exists() && !confPath.isFile()) {
            return true;
        }
        throw new StorageFatalException(50001, "HDFS configuration was not read, please configure hadoop.config.dir or add env:HADOOP_CONF_DIR");
    }

    public FsPath getFsPath(String path) {
        return path.startsWith(this.FILE_SCHEMA()) || path.startsWith(this.HDFS_SCHEMA()) ? new FsPath(path) : new FsPath(new StringBuilder().append((Object)this.FILE_SCHEMA()).append((Object)path).toString());
    }

    public int readBytes(InputStream inputStream, byte[] bytes, int len) {
        int count;
        for (count = 0; count < len; ++count) {
            int value = inputStream.read();
            if (value == -1 && inputStream.available() < 1) {
                return count;
            }
            bytes[count] = (byte)value;
        }
        return count;
    }

    public String colToString(Object col, String nullValue) {
        String string;
        if (col == null) {
            string = nullValue;
        } else {
            String string2;
            Object object = col;
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                string2 = this.doubleToString(d);
            } else {
                boolean bl = "NULL".equals(object) ? true : "".equals(object);
                string2 = bl ? nullValue : col.toString();
            }
            string = string2;
        }
        return string;
    }

    public String colToString$default$2() {
        return "NULL";
    }

    public boolean isIOProxy() {
        return BoxesRunTime.unboxToBoolean((Object)StorageConfiguration$.MODULE$.ENABLE_IO_PROXY().getValue());
    }

    private StorageUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.HDFS = "hdfs";
        this.FILE = "file";
        this.FILE_SCHEMA = "file://";
        this.HDFS_SCHEMA = "hdfs://";
        this.nf = NumberFormat.getInstance();
        this.nf().setGroupingUsed(false);
        this.nf().setMaximumFractionDigits(BoxesRunTime.unboxToInt((Object)StorageConfiguration$.MODULE$.DOUBLE_FRACTION_LEN().getValue()));
    }
}

