/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.IOException;
import java.util.Stack;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.fs.impl.LocalFileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileSystemUtils$
implements Logging {
    public static final FileSystemUtils$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileSystemUtils$();
    }

    private Logger logger$lzycompute() {
        FileSystemUtils$ fileSystemUtils$ = this;
        synchronized (fileSystemUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public void copyFile(FsPath filePath, FsPath origin, String user) {
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(filePath, user);
        Utils$.MODULE$.tryFinally((Function0)new Serializable(filePath, origin, fileSystem){
            public static final long serialVersionUID = 0L;
            private final FsPath filePath$3;
            private final FsPath origin$1;
            private final FileSystem fileSystem$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object;
                this.fileSystem$1.init(null);
                if (this.fileSystem$1.exists(this.filePath$3)) {
                    object = BoxedUnit.UNIT;
                } else {
                    Object object2 = this.fileSystem$1.exists(this.filePath$3.getParent()) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.fileSystem$1.mkdirs(this.filePath$3.getParent()));
                    object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem$1.createNewFile(this.filePath$3));
                }
                return this.fileSystem$1.copyFile(this.origin$1, this.filePath$3);
            }
            {
                this.filePath$3 = filePath$3;
                this.origin$1 = origin$1;
                this.fileSystem$1 = fileSystem$1;
            }
        }, (Function0)new Serializable(fileSystem){
            public static final long serialVersionUID = 0L;
            public final FileSystem fileSystem$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.tryQuietly((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.copyFile.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.fileSystem$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.fileSystem$1 = fileSystem$1;
            }
        });
    }

    public void createNewFile(FsPath filePath, boolean createParentWhenNotExists) {
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFs(filePath);
        Utils$.MODULE$.tryFinally((Function0)new Serializable(filePath, createParentWhenNotExists, fileSystem){
            public static final long serialVersionUID = 0L;
            private final FsPath filePath$2;
            private final boolean createParentWhenNotExists$2;
            private final FileSystem fileSystem$2;

            public final Object apply() {
                block6: {
                    Object object;
                    block3: {
                        block5: {
                            Object object2;
                            block4: {
                                block2: {
                                    this.fileSystem$2.init(null);
                                    if (!this.fileSystem$2.exists(this.filePath$2)) break block2;
                                    object = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!this.fileSystem$2.exists(this.filePath$2.getParent())) break block4;
                                object2 = BoxedUnit.UNIT;
                                break block5;
                            }
                            if (!this.createParentWhenNotExists$2) break block6;
                            object2 = BoxesRunTime.boxToBoolean((boolean)this.fileSystem$2.mkdirs(this.filePath$2.getParent()));
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem$2.createNewFile(this.filePath$2));
                    }
                    return object;
                }
                throw new IOException(new StringBuilder().append((Object)"parent dir ").append((Object)this.filePath$2.getParent().getPath()).append((Object)" dose not exists.").toString());
            }
            {
                this.filePath$2 = filePath$2;
                this.createParentWhenNotExists$2 = createParentWhenNotExists$2;
                this.fileSystem$2 = fileSystem$2;
            }
        }, (Function0)new Serializable(fileSystem){
            public static final long serialVersionUID = 0L;
            public final FileSystem fileSystem$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.tryQuietly((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createNewFile.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.fileSystem$2.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.fileSystem$2 = fileSystem$2;
            }
        });
    }

    public void createNewFile(FsPath filePath, String user, boolean createParentWhenNotExists) {
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(filePath, user);
        Utils$.MODULE$.tryFinally((Function0)new Serializable(filePath, user, createParentWhenNotExists, fileSystem){
            public static final long serialVersionUID = 0L;
            private final FsPath filePath$1;
            private final String user$1;
            private final boolean createParentWhenNotExists$1;
            private final FileSystem fileSystem$3;

            public final Object apply() {
                block9: {
                    BoxedUnit boxedUnit;
                    block6: {
                        Object object;
                        block8: {
                            Object object2;
                            block7: {
                                block5: {
                                    this.fileSystem$3.init(null);
                                    if (!this.fileSystem$3.exists(this.filePath$1)) break block5;
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!this.fileSystem$3.exists(this.filePath$1.getParent())) break block7;
                                object2 = BoxedUnit.UNIT;
                                break block8;
                            }
                            if (!this.createParentWhenNotExists$1) break block9;
                            object2 = BoxesRunTime.boxToBoolean((boolean)FileSystemUtils$.MODULE$.mkdirs(this.fileSystem$3, this.filePath$1.getParent(), this.user$1));
                        }
                        this.fileSystem$3.createNewFile(this.filePath$1);
                        FileSystem fileSystem = this.fileSystem$3;
                        if (fileSystem instanceof LocalFileSystem) {
                            object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem$3.setOwner(this.filePath$1, this.user$1));
                        } else {
                            FileSystemUtils$.MODULE$.info((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doesn't need to call setOwner"})).s((Seq)Nil$.MODULE$);
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit = object;
                    }
                    return boxedUnit;
                }
                throw new IOException(new StringBuilder().append((Object)"parent dir ").append((Object)this.filePath$1.getParent().getPath()).append((Object)" dose not exists.").toString());
            }
            {
                this.filePath$1 = filePath$1;
                this.user$1 = user$1;
                this.createParentWhenNotExists$1 = createParentWhenNotExists$1;
                this.fileSystem$3 = fileSystem$3;
            }
        }, (Function0)new Serializable(fileSystem){
            public static final long serialVersionUID = 0L;
            public final FileSystem fileSystem$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.tryQuietly((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createNewFile.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.fileSystem$3.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.fileSystem$3 = fileSystem$3;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean mkdirs(FileSystem fileSystem, FsPath dest, String user) throws IOException {
        FsPath parentPath = dest.getParent();
        Stack<FsPath> dirsToMake = new Stack<FsPath>();
        dirsToMake.push(dest);
        while (true) {
            FsPath fsPath;
            void var5_5;
            if (fileSystem.exists(parentPath)) {
                if (fileSystem.canExecute(parentPath)) {
                    while (true) {
                        Boolean bl;
                        if (dirsToMake.empty()) {
                            return true;
                        }
                        FsPath path = (FsPath)var5_5.pop();
                        fileSystem.mkdir(path);
                        FileSystem fileSystem2 = fileSystem;
                        if (fileSystem2 instanceof LocalFileSystem) {
                            bl = BoxesRunTime.boxToBoolean((boolean)fileSystem.setOwner(path, user));
                        } else {
                            this.info((Function0<String>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doesn't need to call setOwner"})).s((Seq)Nil$.MODULE$);
                                }
                            });
                            bl = BoxedUnit.UNIT;
                        }
                    }
                }
                throw new IOException(new StringBuilder().append((Object)"You have not permission to access path ").append((Object)dest.getPath()).toString());
            }
            var5_5.push(fsPath);
            fsPath = fsPath.getParent();
        }
    }

    private FileSystemUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

