/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.domain.BigIntType$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.IntType$;
import org.apache.linkis.storage.domain.LongType$;
import org.apache.linkis.storage.domain.ShortIntType$;
import org.apache.linkis.storage.domain.TinyIntType$;
import org.apache.linkis.storage.excel.ExcelFsWriter;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0001\u0003\u00015\u0011!c\u0015;pe\u0006<W-\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\tqa\u001d;pe\u0006<WM\u0003\u0002\b\u0011\u00051A.\u001b8lSNT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"AA\u0007Fq\u000e,GNR:Xe&$XM\u001d\u0005\t'\u0001\u0011)\u0019!C\u0001)\u000591\r[1sg\u0016$X#A\u000b\u0011\u0005YabBA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001e=\t11\u000b\u001e:j]\u001eT!a\u0007\r\t\u0011\u0001\u0002!\u0011!Q\u0001\nU\t\u0001b\u00195beN,G\u000f\t\u0005\tE\u0001\u0011)\u0019!C\u0001)\u0005I1\u000f[3fi:\u000bW.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005+\u0005Q1\u000f[3fi:\u000bW.\u001a\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002Q\t!\u0002Z1uK\u001a{'/\\1u\u0011!A\u0003A!A!\u0002\u0013)\u0012a\u00033bi\u00164uN]7bi\u0002B\u0001B\u000b\u0001\u0003\u0006\u0004%\taK\u0001\r_V$\b/\u001e;TiJ,\u0017-\\\u000b\u0002YA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0003S>T\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\taq*\u001e;qkR\u001cFO]3b[\"AQ\u0007\u0001B\u0001B\u0003%A&A\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\t\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000beR4\bP\u001f\u0011\u0005=\u0001\u0001\"B\n7\u0001\u0004)\u0002\"\u0002\u00127\u0001\u0004)\u0002\"\u0002\u00147\u0001\u0004)\u0002\"\u0002\u00167\u0001\u0004a\u0003\"C \u0001\u0001\u0004\u0005\r\u0011\"\u0005A\u0003!9xN]6C_>\\W#A!\u0011\u0005\tKU\"A\"\u000b\u0005\u0011+\u0015!C:ue\u0016\fW.\u001b8h\u0015\t1u)\u0001\u0003ygN4'B\u0001%\t\u0003\r\u0001x.[\u0005\u0003\u0015\u000e\u0013Qb\u0015-T'\u001a;vN]6c_>\\\u0007\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0005N\u000319xN]6C_>\\w\fJ3r)\tq\u0015\u000b\u0005\u0002\u0018\u001f&\u0011\u0001\u000b\u0007\u0002\u0005+:LG\u000fC\u0004S\u0017\u0006\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007\u0003\u0004U\u0001\u0001\u0006K!Q\u0001\no>\u00148NQ8pW\u0002B\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011C,\u0002\u000bMDW-\u001a;\u0016\u0003a\u0003\"AQ-\n\u0005i\u001b%AC*Y'N35\u000b[3fi\"IA\f\u0001a\u0001\u0002\u0004%\t\"X\u0001\ng\",W\r^0%KF$\"A\u00140\t\u000fI[\u0016\u0011!a\u00011\"1\u0001\r\u0001Q!\na\u000baa\u001d5fKR\u0004\u0003\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0005d\u0003\u00191wN]7biV\tA\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006IQo]3s[>$W\r\u001c\u0006\u0003S\u001e\u000b!a]:\n\u0005-4'A\u0003#bi\u00064uN]7bi\"IQ\u000e\u0001a\u0001\u0002\u0004%\tB\\\u0001\u000bM>\u0014X.\u0019;`I\u0015\fHC\u0001(p\u0011\u001d\u0011F.!AA\u0002\u0011Da!\u001d\u0001!B\u0013!\u0017a\u00024pe6\fG\u000f\t\u0005\ng\u0002\u0001\r\u00111A\u0005\u0012Q\fQ\u0001^=qKN,\u0012!\u001e\t\u0004/YD\u0018BA<\u0019\u0005\u0015\t%O]1z!\tIH0D\u0001{\u0015\tYH!\u0001\u0004e_6\f\u0017N\\\u0005\u0003{j\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\u0012\u0005\u0005\u0011!\u0003;za\u0016\u001cx\fJ3r)\rq\u00151\u0001\u0005\b%z\f\t\u00111\u0001v\u0011\u001d\t9\u0001\u0001Q!\nU\fa\u0001^=qKN\u0004\u0003\"CA\u0006\u0001\u0001\u0007I\u0011CA\u0007\u0003!\u0011xn\u001e)pS:$XCAA\b!\r9\u0012\u0011C\u0005\u0004\u0003'A\"aA%oi\"I\u0011q\u0003\u0001A\u0002\u0013E\u0011\u0011D\u0001\re><\bk\\5oi~#S-\u001d\u000b\u0004\u001d\u0006m\u0001\"\u0003*\u0002\u0016\u0005\u0005\t\u0019AA\b\u0011!\ty\u0002\u0001Q!\n\u0005=\u0011!\u0003:poB{\u0017N\u001c;!\u0011%\t\u0019\u0003\u0001a\u0001\n#\ti!A\u0007d_2,XN\\\"pk:$XM\u001d\u0005\n\u0003O\u0001\u0001\u0019!C\t\u0003S\t\u0011cY8mk6t7i\\;oi\u0016\u0014x\fJ3r)\rq\u00151\u0006\u0005\n%\u0006\u0015\u0012\u0011!a\u0001\u0003\u001fA\u0001\"a\f\u0001A\u0003&\u0011qB\u0001\u000fG>dW/\u001c8D_VtG/\u001a:!\u0011%\t\u0019\u0004\u0001b\u0001\n#\t)$\u0001\u0004tifdWm]\u000b\u0003\u0003o\u0001r!!\u000f\u0002@U\t\u0019%\u0004\u0002\u0002<)\u0019\u0011Q\b\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0003\nYDA\u0004ICNDW*\u00199\u0011\u0007\u0015\f)%C\u0002\u0002H\u0019\u0014\u0011bQ3mYN#\u0018\u0010\\3\t\u0011\u0005-\u0003\u0001)A\u0005\u0003o\tqa\u001d;zY\u0016\u001c\b\u0005C\u0005\u0002P\u0001\u0001\r\u0011\"\u0005\u0002R\u00059\u0011n\u001d$mkNDWCAA*!\r9\u0012QK\u0005\u0004\u0003/B\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u00037\u0002\u0001\u0019!C\t\u0003;\n1\"[:GYV\u001c\bn\u0018\u0013fcR\u0019a*a\u0018\t\u0013I\u000bI&!AA\u0002\u0005M\u0003\u0002CA2\u0001\u0001\u0006K!a\u0015\u0002\u0011%\u001ch\t\\;tQ\u0002B\u0011\"a\u001a\u0001\u0005\u0004%\t\"!\u001b\u0002\u0005=\u001cXCAA6!\ri\u0013QN\u0005\u0004\u0003_r#!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002l\u0005\u0019qn\u001d\u0011\t\u0017\u0005]\u0004\u00011AA\u0002\u0013E\u0011\u0011P\u0001\u0003SN,\"!a\u001f\u0011\u00075\ni(C\u0002\u0002\u00009\u0012ACQ=uK\u0006\u0013(/Y=J]B,Ho\u0015;sK\u0006l\u0007bCAB\u0001\u0001\u0007\t\u0019!C\t\u0003\u000b\u000ba![:`I\u0015\fHc\u0001(\u0002\b\"I!+!!\u0002\u0002\u0003\u0007\u00111\u0010\u0005\t\u0003\u0017\u0003\u0001\u0015)\u0003\u0002|\u0005\u0019\u0011n\u001d\u0011\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006!\u0011N\\5u+\u0005q\u0005bBAK\u0001\u0011\u0005\u0011qS\u0001\u0014O\u0016$H)\u001a4bk2$\b*Z1e'RLH.Z\u000b\u0003\u0003\u0007Bq!a'\u0001\t\u0003\ti*A\u0006hKR<vN]6C_>\\WCAAP!\r)\u0017\u0011U\u0005\u0004\u0003G3'\u0001C,pe.\u0014wn\\6\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006y1M]3bi\u0016\u001cU\r\u001c7TifdW\r\u0006\u0003\u0002D\u0005-\u0006bBAW\u0003K\u0003\r\u0001_\u0001\tI\u0006$\u0018\rV=qK\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016\u0001D4fi\u000e+G\u000e\\*us2,G\u0003BA\"\u0003kCq!!,\u00020\u0002\u0007\u0001\u0010C\u0004\u0002:\u0002!\t%a/\u0002\u0017\u0005$G-T3uC\u0012\u000bG/\u0019\u000b\u0004\u001d\u0006u\u0006\u0002CA`\u0003o\u0003\r!!1\u0002\u00115,G/\u0019#bi\u0006\u0004B!a1\u0002L6\u0011\u0011Q\u0019\u0006\u0004_\u0005\u001d'bAAe\r\u000511m\\7n_:LA!!4\u0002F\nAQ*\u001a;b\t\u0006$\u0018\r\u000b\u0004\u00028\u0006E\u0017Q\u001c\t\u0006/\u0005M\u0017q[\u0005\u0004\u0003+D\"A\u0002;ie><8\u000fE\u0002.\u00033L1!a7/\u0005-Iu*\u0012=dKB$\u0018n\u001c82\ry)\u0012q\u001cB\bc%\u0019\u0013\u0011]At\u0005\u000b\tI/F\u0002\u0015\u0003G$q!!:\r\u0005\u0004\tyOA\u0001U\u0013\u0011\tI/a;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\ti\u000fG\u0001\u0007i\"\u0014xn^:\u0012\t\u0005E\u0018q\u001f\t\u0004/\u0005M\u0018bAA{1\t9aj\u001c;iS:<\u0007\u0003BA}\u0003\u007ft1aFA~\u0013\r\ti\u0010G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\tAa\u0001\u0003\u0013QC'o\\<bE2,'bAA\u007f1EJ1Ea\u0002\u0003\n\t-\u0011Q\u001e\b\u0004/\t%\u0011bAAw1E*!e\u0006\r\u0003\u000e\t)1oY1mCF\u001aa%a6\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u0005I\u0011\r\u001a3SK\u000e|'\u000f\u001a\u000b\u0004\u001d\n]\u0001\u0002\u0003B\r\u0005#\u0001\rAa\u0007\u0002\rI,7m\u001c:e!\u0011\t\u0019M!\b\n\t\t}\u0011Q\u0019\u0002\u0007%\u0016\u001cwN\u001d3)\r\tE\u0011\u0011\u001bB\u0012c\u0019qRC!\n\u0003,EJ1%!9\u0002h\n\u001d\u0012\u0011^\u0019\nG\t\u001d!\u0011\u0002B\u0015\u0003[\fTAI\f\u0019\u0005\u001b\t4AJAl\u0011\u001d\u0011y\u0003\u0001C!\u0005c\tQA\u001a7vg\"$\u0012A\u0014\u0005\b\u0005k\u0001A\u0011\tB\u0019\u0003\u0015\u0019Gn\\:f\u0001")
public class StorageExcelWriter
extends ExcelFsWriter {
    private final String charset;
    private final String sheetName;
    private final String dateFormat;
    private final OutputStream outputStream;
    private SXSSFWorkbook workBook;
    private SXSSFSheet sheet;
    private DataFormat format;
    private DataType[] types;
    private int rowPoint;
    private int columnCounter;
    private final HashMap<String, CellStyle> styles;
    private boolean isFlush;
    private final ByteArrayOutputStream os;
    private ByteArrayInputStream is;

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String sheetName() {
        return this.sheetName;
    }

    @Override
    public String dateFormat() {
        return this.dateFormat;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public SXSSFWorkbook workBook() {
        return this.workBook;
    }

    public void workBook_$eq(SXSSFWorkbook x$1) {
        this.workBook = x$1;
    }

    public SXSSFSheet sheet() {
        return this.sheet;
    }

    public void sheet_$eq(SXSSFSheet x$1) {
        this.sheet = x$1;
    }

    public DataFormat format() {
        return this.format;
    }

    public void format_$eq(DataFormat x$1) {
        this.format = x$1;
    }

    public DataType[] types() {
        return this.types;
    }

    public void types_$eq(DataType[] x$1) {
        this.types = x$1;
    }

    public int rowPoint() {
        return this.rowPoint;
    }

    public void rowPoint_$eq(int x$1) {
        this.rowPoint = x$1;
    }

    public int columnCounter() {
        return this.columnCounter;
    }

    public void columnCounter_$eq(int x$1) {
        this.columnCounter = x$1;
    }

    public HashMap<String, CellStyle> styles() {
        return this.styles;
    }

    public boolean isFlush() {
        return this.isFlush;
    }

    public void isFlush_$eq(boolean x$1) {
        this.isFlush = x$1;
    }

    public ByteArrayOutputStream os() {
        return this.os;
    }

    public ByteArrayInputStream is() {
        return this.is;
    }

    public void is_$eq(ByteArrayInputStream x$1) {
        this.is = x$1;
    }

    public void init() {
        this.workBook_$eq(new SXSSFWorkbook());
        this.sheet_$eq(this.workBook().createSheet(this.sheetName()));
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getDefaultHeadStyle() {
        void var2_2;
        Font headerFont = this.workBook().createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setColor(IndexedColors.RED.getIndex());
        CellStyle headerCellStyle = this.workBook().createCellStyle();
        headerCellStyle.setFont(headerFont);
        return var2_2;
    }

    public Workbook getWorkBook() {
        this.sheet().trackAllColumnsForAutoSizing();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.columnCounter()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageExcelWriter $outer;

            public final void apply(int elem) {
                this.apply$mcVI$sp(elem);
            }

            public void apply$mcVI$sp(int elem) {
                this.$outer.sheet().autoSizeColumn(elem);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.workBook();
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle createCellStyle(DataType dataType) {
        void var2_2;
        CellStyle style = this.workBook().createCellStyle();
        this.format_$eq(this.workBook().createDataFormat());
        DataType dataType2 = dataType;
        boolean bl = BigIntType$.MODULE$.equals(dataType2) ? true : (TinyIntType$.MODULE$.equals(dataType2) ? true : (ShortIntType$.MODULE$.equals(dataType2) ? true : (IntType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2))));
        if (bl) {
            style.setDataFormat(this.format().getFormat("0"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            style.setDataFormat(this.format().getFormat("@"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CellStyle getCellStyle(DataType dataType) {
        CellStyle cellStyle;
        CellStyle style = this.styles().get(dataType.typeName());
        if (style == null) {
            void var3_3;
            CellStyle newStyle = this.createCellStyle(dataType);
            this.styles().put(dataType.typeName(), newStyle);
            cellStyle = var3_3;
        } else {
            cellStyle = style;
        }
        return cellStyle;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        this.init();
        SXSSFRow tableHead = this.sheet().createRow(0);
        Column[] columns = ((TableMetaData)metaData).columns();
        ArrayBuffer columnType = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])columns).foreach((Function1)new Serializable(this, tableHead, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageExcelWriter $outer;
            private final SXSSFRow tableHead$1;
            private final ArrayBuffer columnType$1;

            public final void apply(Column elem) {
                SXSSFCell headCell = this.tableHead$1.createCell(this.$outer.columnCounter());
                headCell.setCellValue(elem.columnName());
                headCell.setCellStyle(this.$outer.getDefaultHeadStyle());
                this.columnType$1.$plus$eq((Object)elem.dataType());
                this.$outer.columnCounter_$eq(this.$outer.columnCounter() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableHead$1 = tableHead$1;
                this.columnType$1 = columnType$1;
            }
        });
        this.types_$eq((DataType[])columnType.toArray(ClassTag$.MODULE$.apply(DataType.class)));
        this.rowPoint_$eq(this.rowPoint() + 1);
    }

    public void addRecord(Record record) throws IOException {
        SXSSFRow tableBody = this.sheet().createRow(this.rowPoint());
        IntRef colunmPoint = IntRef.create((int)0);
        Object[] excelRecord = ((TableRecord)record).row();
        Predef$.MODULE$.genericArrayOps((Object)excelRecord).foreach((Function1)new Serializable(this, tableBody, colunmPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageExcelWriter $outer;
            private final SXSSFRow tableBody$1;
            private final IntRef colunmPoint$1;

            public final void apply(Object elem) {
                SXSSFCell cell = this.tableBody$1.createCell(this.colunmPoint$1.elem);
                DataType dataType = this.$outer.types()[this.colunmPoint$1.elem];
                DataType dataType2 = dataType;
                boolean bl = BigIntType$.MODULE$.equals(dataType2) ? true : (TinyIntType$.MODULE$.equals(dataType2) ? true : (ShortIntType$.MODULE$.equals(dataType2) ? true : (IntType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2))));
                if (bl) {
                    cell.setCellValue(elem.toString().equals("NULL") ? 0.0 : new StringOps(Predef$.MODULE$.augmentString(elem.toString())).toDouble());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    cell.setCellValue(elem.toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                cell.setCellStyle(this.$outer.getCellStyle(dataType));
                ++this.colunmPoint$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableBody$1 = tableBody$1;
                this.colunmPoint$1 = colunmPoint$1;
            }
        });
        this.rowPoint_$eq(this.rowPoint() + 1);
    }

    public void flush() {
        this.getWorkBook().write((OutputStream)this.os());
        byte[] content = this.os().toByteArray();
        this.is_$eq(new ByteArrayInputStream(content));
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (this.isFlush()) {
            bytesRead = this.is().read(buffer, 0, 1024);
            if (bytesRead == -1) {
                this.isFlush_$eq(false);
                continue;
            }
            this.outputStream().write(buffer, 0, bytesRead);
        }
    }

    public void close() {
        if (this.isFlush()) {
            this.flush();
        }
        IOUtils.closeQuietly((OutputStream)this.outputStream());
        IOUtils.closeQuietly((InputStream)this.is());
        IOUtils.closeQuietly((OutputStream)this.os());
        IOUtils.closeQuietly((Closeable)this.workBook());
    }

    public StorageExcelWriter(String charset, String sheetName, String dateFormat, OutputStream outputStream) {
        this.charset = charset;
        this.sheetName = sheetName;
        this.dateFormat = dateFormat;
        this.outputStream = outputStream;
        this.rowPoint = 0;
        this.columnCounter = 0;
        this.styles = new HashMap();
        this.isFlush = true;
        this.os = new ByteArrayOutputStream();
    }
}

