/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage;

import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.exception.StorageFatalException;
import org.apache.linkis.storage.factory.BuildFactory;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class FSFactory$
implements Logging {
    public static final FSFactory$ MODULE$;
    private final Map<String, BuildFactory> buildClasses;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FSFactory$();
    }

    private Logger logger$lzycompute() {
        FSFactory$ fSFactory$ = this;
        synchronized (fSFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private Map<String, BuildFactory> buildClasses() {
        return this.buildClasses;
    }

    public BuildFactory getBuildFactory(String fsName) {
        if (this.buildClasses().contains((Object)fsName)) {
            return (BuildFactory)this.buildClasses().apply((Object)fsName);
        }
        throw new StorageFatalException(50000, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported file system type(\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7cfb\u7edf\u7c7b\u578b)\uff1a", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fsName})));
    }

    public Fs getFs(String fsType, String proxyUser) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fsType).getFs(user, proxyUser);
    }

    public Fs getFs(String fsType) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fsType).getFs(user, user);
    }

    public Fs getFs(FsPath fsPath) {
        return this.getFs(fsPath.getFsType());
    }

    public Fs getFsByProxyUser(FsPath fsPath, String proxyUser) {
        return this.getFs(fsPath.getFsType(), proxyUser);
    }

    public Fs getFSByLabel(String fs, String label) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fs).getFs(user, user, label);
    }

    public Fs getFSByLabelAndUser(String fs, String label, String proxy) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fs).getFs(user, proxy, label);
    }

    private FSFactory$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.buildClasses = StorageUtils$.MODULE$.loadClass((String)StorageConfiguration$.MODULE$.STORAGE_BUILD_FS_CLASSES().getValue(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BuildFactory t) {
                return t.fsName();
            }
        });
    }
}

