/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.utils;

import com.netflix.client.ClientException;
import feign.RetryableException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.rpc.BaseRPCSender;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.exception.NoInstanceExistsException;
import org.apache.linkis.rpc.sender.SpringCloudFeignConfigurationCache$;
import org.apache.linkis.rpc.sender.SpringMVCRPCSender;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;

public final class RPCUtils$ {
    public static final RPCUtils$ MODULE$;

    static {
        new RPCUtils$();
    }

    public boolean isReceiverNotExists(Throwable t) {
        boolean bl;
        Throwable throwable = t;
        if (throwable instanceof ConnectException) {
            ConnectException connectException = (ConnectException)throwable;
            bl = connectException.getMessage() != null && connectException.getMessage().contains("Connection refused");
        } else if (throwable instanceof NoInstanceExistsException) {
            bl = true;
        } else if (throwable instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)throwable;
            Throwable throwable2 = undeclaredThrowableException.getCause();
            boolean bl2 = throwable2 instanceof NoInstanceExistsException;
            bl = bl2;
        } else if (throwable instanceof RetryableException) {
            ConnectException connectException;
            RetryableException retryableException = (RetryableException)throwable;
            Throwable throwable3 = retryableException.getCause();
            boolean bl3 = throwable3 instanceof ConnectException ? (connectException = (ConnectException)throwable3).getMessage() != null && connectException.getMessage().contains("Connection refused") : false;
            bl = bl3;
        } else if (throwable instanceof RuntimeException) {
            ClientException clientException;
            RuntimeException runtimeException = (RuntimeException)throwable;
            Throwable throwable4 = runtimeException.getCause();
            boolean bl4 = throwable4 instanceof ClientException ? StringUtils.isNotBlank((String)(clientException = (ClientException)throwable4).getErrorMessage()) && clientException.getErrorMessage().contains("Load balancer does not have available server for client") : false;
            bl = bl4;
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<String> findService(String parsedServiceId, Function1<List<String>, Option<String>> tooManyDeal) {
        List services = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(SpringCloudFeignConfigurationCache$.MODULE$.getDiscoveryClient().getServices()).filter((Function1)new Serializable(parsedServiceId){
            public static final long serialVersionUID = 0L;
            private final String parsedServiceId$1;

            public final boolean apply(String x$1) {
                return x$1.toLowerCase().contains(this.parsedServiceId$1.toLowerCase());
            }
            {
                this.parsedServiceId$1 = parsedServiceId$1;
            }
        })).toList();
        return services.length() == 1 ? new Some(services.head()) : (services.length() > 1 ? (Option)tooManyDeal.apply((Object)services) : None$.MODULE$);
    }

    public ServiceInstance getServiceInstanceFromSender(Sender sender) {
        ServiceInstance serviceInstance;
        Sender sender2 = sender;
        if (sender2 instanceof SpringMVCRPCSender) {
            SpringMVCRPCSender springMVCRPCSender = (SpringMVCRPCSender)sender2;
            serviceInstance = springMVCRPCSender.serviceInstance();
        } else if (sender2 instanceof BaseRPCSender) {
            BaseRPCSender baseRPCSender = (BaseRPCSender)sender2;
            serviceInstance = ServiceInstance$.MODULE$.apply(baseRPCSender.getApplicationName(), null);
        } else {
            serviceInstance = null;
        }
        return serviceInstance;
    }

    private RPCUtils$() {
        MODULE$ = this;
    }
}

