/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.interceptor.common;

import feign.RetryableException;
import java.net.ConnectException;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.RetryHandler;
import org.apache.linkis.protocol.Protocol;
import org.apache.linkis.protocol.RetryableProtocol;
import org.apache.linkis.rpc.exception.DWCRPCRetryException;
import org.apache.linkis.rpc.exception.DWCRPCRetryException$;
import org.apache.linkis.rpc.interceptor.RPCInterceptor;
import org.apache.linkis.rpc.interceptor.RPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.RPCInterceptorExchange;
import org.apache.linkis.rpc.interceptor.ServiceInstanceRPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.common.RetryableRPCInterceptor$;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001=\u0011qCU3uef\f'\r\\3S!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0005\r!\u0011AB2p[6|gN\u0003\u0002\u0006\r\u0005Y\u0011N\u001c;fe\u000e,\u0007\u000f^8s\u0015\t9\u0001\"A\u0002sa\u000eT!!\u0003\u0006\u0002\r1Lgn[5t\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0005\u0013\tIBA\u0001\bS!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t%I\u0001\u0006_J$WM]\u000b\u0002EA\u0011\u0011cI\u0005\u0003II\u00111!\u00138u\u0011\u00191\u0003\u0001)A\u0005E\u00051qN\u001d3fe\u0002BQ\u0001\u000b\u0001\u0005B%\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0015\u0007)j#\u0007\u0005\u0002\u0012W%\u0011AF\u0005\u0002\u0004\u0003:L\b\"\u0002\u0018(\u0001\u0004y\u0013aE5oi\u0016\u00148-\u001a9u_J,\u0005p\u00195b]\u001e,\u0007CA\f1\u0013\t\tDA\u0001\fS!\u000eKe\u000e^3sG\u0016\u0004Ho\u001c:Fq\u000eD\u0017M\\4f\u0011\u0015\u0019t\u00051\u00015\u0003\u0015\u0019\u0007.Y5o!\t9R'\u0003\u00027\t\t\u0019\"\u000bU\"J]R,'oY3qi>\u00148\t[1j]\u001a!\u0001\b\u0001\u0001:\u0005=\u0011\u0006k\u0011*fiJL\b*\u00198eY\u0016\u00148cA\u001c\u0011uA\u00111hP\u0007\u0002y)\u0011QHP\u0001\u0006kRLGn\u001d\u0006\u0003\u0007!I!\u0001\u0011\u001f\u0003\u0019I+GO]=IC:$G.\u001a:\t\u000bm9D\u0011\u0001\"\u0015\u0003\r\u0003\"\u0001R\u001c\u000e\u0003\u0001AqAR\u001cA\u0002\u0013%q)A\btKJ4\u0018nY3J]N$\u0018M\\2f+\u0005A\u0005cA\tJ\u0017&\u0011!J\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051kU\"\u0001 \n\u00059s$aD*feZL7-Z%ogR\fgnY3\t\u000fA;\u0004\u0019!C\u0005#\u0006\u00192/\u001a:wS\u000e,\u0017J\\:uC:\u001cWm\u0018\u0013fcR\u0011!+\u0016\t\u0003#MK!\u0001\u0016\n\u0003\tUs\u0017\u000e\u001e\u0005\b->\u000b\t\u00111\u0001I\u0003\rAH%\r\u0005\u00071^\u0002\u000b\u0015\u0002%\u0002!M,'O^5dK&s7\u000f^1oG\u0016\u0004\u0003\"\u0002.8\t\u0003Y\u0016\u0001D:fiJ+GO]=J]\u001a|Gc\u0001*]I\")Q,\u0017a\u0001=\u0006)!/\u001a;ssB\u0011qLY\u0007\u0002A*\u0011\u0011\rC\u0001\taJ|Go\\2pY&\u00111\r\u0019\u0002\u0012%\u0016$(/_1cY\u0016\u0004&o\u001c;pG>d\u0007\"B\u001aZ\u0001\u0004!\u0004\"\u000248\t\u00139\u0017\u0001F5t\u001d>\u001cVM\u001d<jG\u0016,\u0005pY3qi&|g\u000e\u0006\u0002iWB\u0011\u0011#[\u0005\u0003UJ\u0011qAQ8pY\u0016\fg\u000eC\u0003mK\u0002\u0007Q.A\u0001u!\tqgO\u0004\u0002pi:\u0011\u0001o]\u0007\u0002c*\u0011!OD\u0001\u0007yI|w\u000e\u001e \n\u0003MI!!\u001e\n\u0002\u000fA\f7m[1hK&\u0011q\u000f\u001f\u0002\n)\"\u0014xn^1cY\u0016T!!\u001e\n\t\u000bi<D\u0011I>\u0002#\u0015D8-\u001a9uS>t7)\u00198SKR\u0014\u0018\u0010\u0006\u0002iy\")A.\u001fa\u0001[\"\u0012\u0001A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0015M$XM]3pif\u0004XMC\u0002\u0002\b1\tqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u0003\u0017\t\tAA\u0005D_6\u0004xN\\3oi\u001e9\u0011q\u0002\u0002\t\u0002\u0005E\u0011a\u0006*fiJL\u0018M\u00197f%B\u001b\u0015J\u001c;fe\u000e,\u0007\u000f^8s!\rq\u00121\u0003\u0004\u0007\u0003\tA\t!!\u0006\u0014\u0007\u0005M\u0001\u0003C\u0004\u001c\u0003'!\t!!\u0007\u0015\u0005\u0005E\u0001\u0002CA\u000f\u0003'!\t!a\b\u0002'%\u001c(+\u001a;ss\u0006\u0014G.\u001a)s_R|7m\u001c7\u0015\u0007!\f\t\u0003C\u0004\u0002$\u0005m\u0001\u0019\u0001\u0016\u0002\u000f5,7o]1hK\u0002")
public class RetryableRPCInterceptor
implements RPCInterceptor {
    private final int order;

    public static boolean isRetryableProtocol(Object object) {
        return RetryableRPCInterceptor$.MODULE$.isRetryableProtocol(object);
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public Object intercept(RPCInterceptorExchange interceptorExchange, RPCInterceptorChain chain) {
        Object object;
        Protocol protocol = interceptorExchange.getProtocol();
        if (protocol instanceof RetryableProtocol) {
            RetryableProtocol retryableProtocol = (RetryableProtocol)protocol;
            String retryName = retryableProtocol.getClass().getSimpleName();
            RPCRetryHandler retryHandler = new RPCRetryHandler();
            retryHandler.setRetryInfo(retryableProtocol, chain);
            object = retryHandler.retry(new Serializable(this, interceptorExchange, chain){
                public static final long serialVersionUID = 0L;
                private final RPCInterceptorExchange interceptorExchange$1;
                private final RPCInterceptorChain chain$1;

                public final Object apply() {
                    return this.chain$1.handle(this.interceptorExchange$1);
                }
                {
                    this.interceptorExchange$1 = interceptorExchange$1;
                    this.chain$1 = chain$1;
                }
            }, retryName);
        } else {
            object = chain.handle(interceptorExchange);
        }
        return object;
    }

    public RetryableRPCInterceptor() {
        this.order = 20;
    }

    public class RPCRetryHandler
    implements RetryHandler {
        private Option<ServiceInstance> serviceInstance;
        private int org$apache$linkis$common$utils$RetryHandler$$retryNum;
        private long org$apache$linkis$common$utils$RetryHandler$$period;
        private long org$apache$linkis$common$utils$RetryHandler$$maxPeriod;
        private final ArrayBuffer<Class<? extends Throwable>> org$apache$linkis$common$utils$RetryHandler$$retryExceptions;
        private final Logger logger;
        private volatile boolean bitmap$0;

        public int org$apache$linkis$common$utils$RetryHandler$$retryNum() {
            return this.org$apache$linkis$common$utils$RetryHandler$$retryNum;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$retryNum_$eq(int x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$retryNum = x$1;
        }

        public long org$apache$linkis$common$utils$RetryHandler$$period() {
            return this.org$apache$linkis$common$utils$RetryHandler$$period;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$period_$eq(long x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$period = x$1;
        }

        public long org$apache$linkis$common$utils$RetryHandler$$maxPeriod() {
            return this.org$apache$linkis$common$utils$RetryHandler$$maxPeriod;
        }

        public void org$apache$linkis$common$utils$RetryHandler$$maxPeriod_$eq(long x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$maxPeriod = x$1;
        }

        public ArrayBuffer<Class<? extends Throwable>> org$apache$linkis$common$utils$RetryHandler$$retryExceptions() {
            return this.org$apache$linkis$common$utils$RetryHandler$$retryExceptions;
        }

        public void org$apache$linkis$common$utils$RetryHandler$_setter_$org$apache$linkis$common$utils$RetryHandler$$retryExceptions_$eq(ArrayBuffer x$1) {
            this.org$apache$linkis$common$utils$RetryHandler$$retryExceptions = x$1;
        }

        public void setRetryNum(int retryNum) {
            RetryHandler.class.setRetryNum((RetryHandler)this, (int)retryNum);
        }

        public int getRetryNum() {
            return RetryHandler.class.getRetryNum((RetryHandler)this);
        }

        public void setRetryPeriod(long retryPeriod) {
            RetryHandler.class.setRetryPeriod((RetryHandler)this, (long)retryPeriod);
        }

        public long getRetryPeriod() {
            return RetryHandler.class.getRetryPeriod((RetryHandler)this);
        }

        public void setRetryMaxPeriod(long retryMaxPeriod) {
            RetryHandler.class.setRetryMaxPeriod((RetryHandler)this, (long)retryMaxPeriod);
        }

        public long getRetryMaxPeriod() {
            return RetryHandler.class.getRetryMaxPeriod((RetryHandler)this);
        }

        public void addRetryException(Class<? extends Throwable> t) {
            RetryHandler.class.addRetryException((RetryHandler)this, t);
        }

        public Class<? extends Throwable>[] getRetryExceptions() {
            return RetryHandler.class.getRetryExceptions((RetryHandler)this);
        }

        public long nextInterval(int attempt) {
            return RetryHandler.class.nextInterval((RetryHandler)this, (int)attempt);
        }

        public <T> T retry(Function0<T> op, String retryName) {
            return (T)RetryHandler.class.retry((RetryHandler)this, op, (String)retryName);
        }

        private Logger logger$lzycompute() {
            RPCRetryHandler rPCRetryHandler = this;
            synchronized (rPCRetryHandler) {
                if (!this.bitmap$0) {
                    this.logger = Logging.class.logger((Logging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public void trace(Function0<String> message) {
            Logging.class.trace((Logging)this, message);
        }

        public void debug(Function0<String> message) {
            Logging.class.debug((Logging)this, message);
        }

        public void info(Function0<String> message) {
            Logging.class.info((Logging)this, message);
        }

        public void info(Function0<String> message, Throwable t) {
            Logging.class.info((Logging)this, message, (Throwable)t);
        }

        public void warn(Function0<String> message) {
            Logging.class.warn((Logging)this, message);
        }

        public void warn(Function0<String> message, Throwable t) {
            Logging.class.warn((Logging)this, message, (Throwable)t);
        }

        public void error(Function0<String> message, Throwable t) {
            Logging.class.error((Logging)this, message, (Throwable)t);
        }

        public void error(Function0<String> message) {
            Logging.class.error((Logging)this, message);
        }

        private Option<ServiceInstance> serviceInstance() {
            return this.serviceInstance;
        }

        private void serviceInstance_$eq(Option<ServiceInstance> x$1) {
            this.serviceInstance = x$1;
        }

        public void setRetryInfo(RetryableProtocol retry, RPCInterceptorChain chain) {
            this.setRetryNum(retry.retryNum());
            this.setRetryPeriod(retry.period());
            this.setRetryMaxPeriod(retry.maxPeriod());
            Predef$.MODULE$.refArrayOps((Object[])retry.retryExceptions()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RPCRetryHandler $outer;

                public final void apply(Class<? extends Throwable> t) {
                    this.$outer.addRetryException(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            RPCInterceptorChain rPCInterceptorChain = chain;
            if (rPCInterceptorChain instanceof ServiceInstanceRPCInterceptorChain) {
                ServiceInstanceRPCInterceptorChain serviceInstanceRPCInterceptorChain = (ServiceInstanceRPCInterceptorChain)rPCInterceptorChain;
                this.serviceInstance_$eq((Option<ServiceInstance>)Option$.MODULE$.apply((Object)serviceInstanceRPCInterceptorChain.getServiceInstance()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        private boolean isNoServiceException(Throwable t) {
            return RPCUtils$.MODULE$.isReceiverNotExists(t);
        }

        public boolean exceptionCanRetry(Throwable t) {
            LinkisRetryException linkisRetryException;
            Throwable throwable = t;
            boolean bl = throwable instanceof DWCRPCRetryException ? true : (throwable instanceof LinkisRetryException ? (linkisRetryException = (LinkisRetryException)throwable).getErrCode() == DWCRPCRetryException$.MODULE$.RPC_RETRY_ERROR_CODE() : this.serviceInstance().exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ServiceInstance s) {
                    return StringUtils.isBlank((String)s.getInstance());
                }
            }) && this.isNoServiceException(t) || RetryHandler.class.exceptionCanRetry((RetryHandler)this, (Throwable)t));
            return bl;
        }

        public /* synthetic */ RetryableRPCInterceptor org$apache$linkis$rpc$interceptor$common$RetryableRPCInterceptor$RPCRetryHandler$$$outer() {
            return RetryableRPCInterceptor.this;
        }

        public RPCRetryHandler() {
            if (RetryableRPCInterceptor.this == null) {
                throw null;
            }
            Logging.class.$init$((Logging)this);
            RetryHandler.class.$init$((RetryHandler)this);
            this.addRetryException(ConnectException.class);
            this.addRetryException(RetryableException.class);
            this.serviceInstance = None$.MODULE$;
        }
    }
}

