/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.conf;

import com.netflix.discovery.EurekaClient;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.DataWorkCloudApplication;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.rpc.RPCReceiveRestful;
import org.apache.linkis.rpc.interceptor.RPCServerLoader;
import org.apache.linkis.rpc.sender.eureka.EurekaRPCServerLoader;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Configuration
@EnableFeignClients
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\t1\"\u000bU\"TaJLgnZ\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u0004\t\u0005!1m\u001c8g\u0015\t)a!A\u0002sa\u000eT!a\u0002\u0005\u0002\r1Lgn[5t\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\"$D\u0001\u0017\u0015\t9\u0002$A\u0003vi&d7O\u0003\u0002\u001a\r\u000511m\\7n_:L!a\u0007\f\u0003\u000f1{wmZ5oO\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\taI\u0001\u0016GJ,\u0017\r^3S!\u000e\u001bVM\u001d<fe2{\u0017\rZ3s)\u0005!\u0003CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003-Ig\u000e^3sG\u0016\u0004Ho\u001c:\n\u0005%2#a\u0004*Q\u0007N+'O^3s\u0019>\fG-\u001a:)\u0005\u0005Z\u0003C\u0001\u00176\u001b\u0005i#B\u0001\u00180\u0003%\u0019wN\u001c3ji&|gN\u0003\u00021c\u0005i\u0011-\u001e;pG>tg-[4ve\u0016T!AM\u001a\u0002\t\t|w\u000e\u001e\u0006\u0003i)\tqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003m5\u0012\u0001dQ8oI&$\u0018n\u001c8bY>sW*[:tS:<')Z1oQ\u0011\t\u0003h\u000f\u001f\u0011\u00051J\u0014B\u0001\u001e.\u0005I\u0019uN\u001c3ji&|g.\u00197P]\u000ec\u0017m]:\u0002\u000bY\fG.^3-\u0003u\u001a\u0013A\u0010\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\u0002Z5tG>4XM]=\u000b\u0005\r#\u0015a\u00028fi\u001ad\u0017\u000e\u001f\u0006\u0002\u000b\u0006\u00191m\\7\n\u0005\u001d\u0003%\u0001D#ve\u0016\\\u0017m\u00117jK:$\b\u0006B\u0011JwE\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002Og\u000591m\u001c8uKb$\u0018B\u0001)L\u0005\u0011\u0011U-\u00198-\u0003I\u000b\u0013aU\u0001\u0010eB\u001c7+\u001a:wKJdu.\u00193fe\")Q\u000b\u0001C\u0001-\u0006\u00112m\\7qY\u0016$X-\u00138ji&\fG.\u001b>f)\t9&\f\u0005\u0002\u00101&\u0011\u0011\f\u0005\u0002\u0005+:LG\u000fC\u0003\\)\u0002\u0007A,\u0001\rbaBd\u0017nY1uS>t\u0007K]3qCJ,G-\u0012<f]R\u0004\"!X1\u000e\u0003yS!a\u00181\u0002\u000b\u00154XM\u001c;\u000b\u00059\u000b\u0014B\u00012_\u0005a\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Qe\u0016\u0004\u0018M]3e\u000bZ,g\u000e\u001e\u0015\u0003)\u0012\u0004\"!Z4\u000e\u0003\u0019T!aX'\n\u0005!4'!D#wK:$H*[:uK:,'\u000f\u000b\u0002\u0001UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\n_B,gNZ3jO:T!a\\\u001a\u0002\u000b\rdw.\u001e3\n\u0005Ed'AE#oC\ndWMR3jO:\u001cE.[3oiND#\u0001A:\u0011\u0005)#\u0018BA;L\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class RPCSpringConfiguration
implements Logging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        RPCSpringConfiguration rPCSpringConfiguration = this;
        synchronized (rPCSpringConfiguration) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Bean(value={"rpcServerLoader"})
    @ConditionalOnClass(value={EurekaClient.class})
    @ConditionalOnMissingBean
    public RPCServerLoader createRPCServerLoader() {
        return new EurekaRPCServerLoader();
    }

    @EventListener
    public void completeInitialize(ApplicationPreparedEvent applicationPreparedEvent) {
        String restfulClasses = (String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().getValue();
        String rpcRestfulName = applicationPreparedEvent.getApplicationContext().getBean(RPCReceiveRestful.class).getClass().getName();
        if (StringUtils.isEmpty((String)restfulClasses)) {
            DataWorkCloudApplication.setProperty((String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().key(), (String)rpcRestfulName);
        } else {
            DataWorkCloudApplication.setProperty((String)ServerConfiguration$.MODULE$.BDP_SERVER_RESTFUL_REGISTER_CLASSES().key(), (String)new StringBuilder().append((Object)restfulClasses).append((Object)",").append((Object)rpcRestfulName).toString());
        }
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DataWorkCloud RPC need register RPCReceiveRestful, now add it to configuration.";
            }
        });
    }

    public RPCSpringConfiguration() {
        Logging.class.$init$((Logging)this);
    }
}

