/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.ConsumerThreadId;
import kafka.tools.VerifyConsumerRebalance$;
import kafka.tools.VerifyConsumerRebalance$$anonfun$validateRebalancingOperation$2$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class VerifyConsumerRebalance$
implements Logging {
    public static final VerifyConsumerRebalance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new VerifyConsumerRebalance$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        VerifyConsumerRebalance$ verifyConsumerRebalance$ = this;
        synchronized (verifyConsumerRebalance$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        block9: {
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper.connect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
            ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
            parser.accepts("help", "Print this message.");
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all partitions have a consumer for a given consumer group.");
            }
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{groupOpt}));
            String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
            String group = (String)options.valueOf((OptionSpec)groupOpt);
            try (ZkUtils zkUtils = null;){
                zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
                this.debug((Function0<String>)new Serializable(zkConnect, group){
                    public static final long serialVersionUID = 0L;
                    private final String zkConnect$1;
                    private final String group$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("zkConnect = %s; group = %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect$1, this.group$1}));
                    }
                    {
                        this.zkConnect$1 = zkConnect$1;
                        this.group$1 = group$1;
                    }
                });
                try {
                    if (this.validateRebalancingOperation(zkUtils, group)) {
                        Predef$.MODULE$.println((Object)"Rebalance operation successful !");
                        break block9;
                    }
                    Predef$.MODULE$.println((Object)"Rebalance operation failed !");
                }
                catch (Throwable throwable) {
                    this.error((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error while verifying current rebalancing operation";
                        }
                    }, (Function0<Throwable>)new Serializable(throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e2$1;

                        public final Throwable apply() {
                            return this.e2$1;
                        }
                        {
                            this.e2$1 = e2$1;
                        }
                    });
                }
            }
        }
    }

    private boolean validateRebalancingOperation(ZkUtils zkUtils, String group) {
        this.info((Function0<String>)new Serializable(group){
            public static final long serialVersionUID = 0L;
            private final String group$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Verifying rebalancing operation for consumer group ").append((Object)this.group$2).toString();
            }
            {
                this.group$2 = group$2;
            }
        });
        BooleanRef rebalanceSucceeded = new BooleanRef(true);
        Map<String, List<ConsumerThreadId>> consumersPerTopicMap = zkUtils.getConsumersPerTopic(group, false);
        Map<String, Seq<Object>> partitionsPerTopicMap = zkUtils.getPartitionsForTopics((Seq<String>)consumersPerTopicMap.keySet().toSeq());
        partitionsPerTopicMap.foreach((Function1)new Serializable(zkUtils, group, rebalanceSucceeded, consumersPerTopicMap){
            public static final long serialVersionUID = 0L;
            public final ZkUtils zkUtils$1;
            public final String group$2;
            public final BooleanRef rebalanceSucceeded$1;
            public final Map consumersPerTopicMap$1;

            public final void apply(Tuple2<String, Seq<Object>> x0$1) {
                Tuple2<String, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    Seq partitions = (Seq)tuple2._2();
                    ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.group$2, topic);
                    VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, topic, partitions){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Seq partitions$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Alive partitions for topic %s are %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.partitions$1.toString()}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.partitions$1 = partitions$1;
                        }
                    });
                    VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.validateRebalancingOperation.2 $outer;
                        private final String topic$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Alive consumers for topic %s => %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.$outer.consumersPerTopicMap$1.get((Object)this.topic$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$1 = topic$1;
                        }
                    });
                    Seq<String> partitionsWithOwners = this.zkUtils$1.getChildrenParentMayNotExist(topicDirs.consumerOwnerDir());
                    if (partitionsWithOwners.size() == 0) {
                        VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, topic){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"No owners for any partitions for topic ").append((Object)this.topic$1).toString();
                            }
                            {
                                this.topic$1 = topic$1;
                            }
                        });
                        this.rebalanceSucceeded$1.elem = false;
                    }
                    VerifyConsumerRebalance$.MODULE$.debug((Function0<String>)new Serializable(this, topicDirs, partitionsWithOwners){
                        public static final long serialVersionUID = 0L;
                        private final ZKGroupTopicDirs topicDirs$1;
                        private final Seq partitionsWithOwners$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Children of ").append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)" = ").append((Object)this.partitionsWithOwners$1.toString()).toString();
                        }
                        {
                            this.topicDirs$1 = topicDirs$1;
                            this.partitionsWithOwners$1 = partitionsWithOwners$1;
                        }
                    });
                    Option consumerIdsForTopic = this.consumersPerTopicMap$1.get((Object)topic);
                    partitions.foreach((Function1)new Serializable(this, topic, topicDirs, partitionsWithOwners, consumerIdsForTopic){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.validateRebalancingOperation.2 $outer;
                        public final String topic$1;
                        private final ZKGroupTopicDirs topicDirs$1;
                        private final Seq partitionsWithOwners$1;
                        private final Option consumerIdsForTopic$1;

                        public final void apply(int partition) {
                            this.apply$mcVI$sp(partition);
                        }

                        public void apply$mcVI$sp(int partition) {
                            Option option;
                            block8: {
                                Option option2;
                                block12: {
                                    block10: {
                                        block11: {
                                            BoxedUnit boxedUnit;
                                            String partitionOwner;
                                            block9: {
                                                String string;
                                                block7: {
                                                    block6: {
                                                        String m;
                                                        String partitionOwnerPath;
                                                        if (!this.partitionsWithOwners$1.contains((Object)((Object)BoxesRunTime.boxToInteger((int)partition)).toString())) {
                                                            VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, partition){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                                private final int partition$1;

                                                                public final String apply() {
                                                                    return new StringOps(Predef$.MODULE$.augmentString("No owner for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw new NullPointerException();
                                                                    }
                                                                    this.$outer = $outer;
                                                                    this.partition$1 = partition$1;
                                                                }
                                                            });
                                                            this.$outer.rebalanceSucceeded$1.elem = false;
                                                        }
                                                        if (!((option = (Option)this.$outer.zkUtils$1.readDataMaybeNull(partitionOwnerPath = new StringBuilder().append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString())._1()) instanceof Some)) break block6;
                                                        Some some = (Some)option;
                                                        string = m = (String)some.x();
                                                        break block7;
                                                    }
                                                    None$ none$ = None$.MODULE$;
                                                    Option option3 = option;
                                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block8;
                                                    string = null;
                                                }
                                                partitionOwner = string;
                                                if (partitionOwner != null) break block9;
                                                VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, partition){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                    private final int partition$1;

                                                    public final String apply() {
                                                        return new StringOps(Predef$.MODULE$.augmentString("No owner for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.partition$1 = partition$1;
                                                    }
                                                });
                                                this.$outer.rebalanceSucceeded$1.elem = false;
                                                break block10;
                                            }
                                            option2 = this.consumerIdsForTopic$1;
                                            if (!(option2 instanceof Some)) break block11;
                                            Some some = (Some)option2;
                                            List consumerIds = (List)some.x();
                                            if (((LinearSeqOptimized)consumerIds.map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply(ConsumerThreadId c) {
                                                    return c.toString();
                                                }
                                            }, List$.MODULE$.canBuildFrom())).contains((Object)partitionOwner)) {
                                                VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, partitionOwner, partition){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                    private final String partitionOwner$1;
                                                    private final int partition$1;

                                                    public final String apply() {
                                                        return new StringOps(Predef$.MODULE$.augmentString("Owner of partition [%s,%d] is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.partitionOwner$1}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.partitionOwner$1 = partitionOwner$1;
                                                        this.partition$1 = partition$1;
                                                    }
                                                });
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, partitionOwner, partition){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                    private final String partitionOwner$1;
                                                    private final int partition$1;

                                                    public final String apply() {
                                                        return new StringOps(Predef$.MODULE$.augmentString("Owner %s for partition [%s,%d] is not a valid member of consumer group %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionOwner$1, this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.$outer.kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer().group$2}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.partitionOwner$1 = partitionOwner$1;
                                                        this.partition$1 = partition$1;
                                                    }
                                                });
                                                this.$outer.rebalanceSucceeded$1.elem = false;
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            break block10;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option4 = option2;
                                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block12;
                                        VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"No consumer ids registered for topic ").append((Object)this.$outer.topic$1).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.rebalanceSucceeded$1.elem = false;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return;
                                }
                                throw new MatchError((Object)option2);
                            }
                            throw new MatchError((Object)option);
                        }

                        public /* synthetic */ anonfun.validateRebalancingOperation.2 kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$1 = topic$1;
                            this.topicDirs$1 = topicDirs$1;
                            this.partitionsWithOwners$1 = partitionsWithOwners$1;
                            this.consumerIdsForTopic$1 = consumerIdsForTopic$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.group$2 = group$2;
                this.rebalanceSucceeded$1 = rebalanceSucceeded$1;
                this.consumersPerTopicMap$1 = consumersPerTopicMap$1;
            }
        });
        return rebalanceSucceeded.elem;
    }

    private VerifyConsumerRebalance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

