/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;

public final class RegionToAdminEndpointURI
implements Function<Object, URI> {
    private final RegionIdToAdminURISupplier regionToAdminEndpoints;

    @Inject
    RegionToAdminEndpointURI(RegionIdToAdminURISupplier regionToAdminEndpoints) {
        this.regionToAdminEndpoints = regionToAdminEndpoints;
    }

    public URI apply(Object from) {
        Map regionToAdminEndpoint = (Map)this.regionToAdminEndpoints.get();
        Preconditions.checkState((!regionToAdminEndpoint.isEmpty() ? 1 : 0) != 0, (Object)"no region name to admin endpoint mappings in keystone!");
        Preconditions.checkArgument((boolean)regionToAdminEndpoint.containsKey(from), (String)"requested location %s, which is not in the keystone admin endpoints: %s", (Object[])new Object[]{from, regionToAdminEndpoint});
        return (URI)((Supplier)regionToAdminEndpoint.get(from)).get();
    }
}

