/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata.repository.query;

import java.lang.reflect.Method;
import org.apache.ignite.springdata.repository.query.IgniteQuery;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class IgniteQueryGenerator {
    @NotNull
    public static IgniteQuery generateSql(Method mtd, RepositoryMetadata metadata) {
        PartTree parts = new PartTree(mtd.getName(), metadata.getDomainType());
        StringBuilder sql = new StringBuilder();
        if (parts.isDelete().booleanValue()) {
            throw new UnsupportedOperationException("DELETE clause is not supported now.");
        }
        sql.append("SELECT ");
        if (parts.isDistinct()) {
            throw new UnsupportedOperationException("DISTINCT clause in not supported.");
        }
        if (parts.isCountProjection().booleanValue()) {
            sql.append("COUNT(1) ");
        } else {
            sql.append(" * ");
        }
        sql.append("FROM ").append(metadata.getDomainType().getSimpleName());
        if (parts.iterator().hasNext()) {
            sql.append(" WHERE ");
            for (PartTree.OrPart orPart : parts) {
                sql.append("(");
                for (Part part : orPart) {
                    IgniteQueryGenerator.handleQueryPart(sql, part);
                    sql.append(" AND ");
                }
                sql.delete(sql.length() - 5, sql.length());
                sql.append(") OR ");
            }
            sql.delete(sql.length() - 4, sql.length());
        }
        IgniteQueryGenerator.addSorting(sql, parts.getSort());
        if (parts.isLimiting()) {
            sql.append(" LIMIT ");
            sql.append(parts.getMaxResults());
        }
        return new IgniteQuery(sql.toString(), parts.isCountProjection(), IgniteQueryGenerator.getOptions(mtd));
    }

    public static StringBuilder addSorting(StringBuilder sql, Sort sort) {
        if (sort != null) {
            sql.append(" ORDER BY ");
            for (Sort.Order order : sort) {
                sql.append(order.getProperty()).append(" ").append(order.getDirection());
                if (order.getNullHandling() != Sort.NullHandling.NATIVE) {
                    sql.append(" ").append("NULL ");
                    switch (order.getNullHandling()) {
                        case NULLS_FIRST: {
                            sql.append("FIRST");
                            break;
                        }
                        case NULLS_LAST: {
                            sql.append("LAST");
                        }
                    }
                }
                sql.append(", ");
            }
            sql.delete(sql.length() - 2, sql.length());
        }
        return sql;
    }

    public static StringBuilder addPaging(StringBuilder sql, Pageable pageable) {
        if (pageable.getSort() != null) {
            IgniteQueryGenerator.addSorting(sql, pageable.getSort());
        }
        sql.append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
        return sql;
    }

    public static IgniteQuery.Option getOptions(Method mtd) {
        Class<?>[] types = mtd.getParameterTypes();
        Class<?> type = types[types.length - 1];
        IgniteQuery.Option option = Sort.class.isAssignableFrom(type) ? IgniteQuery.Option.SORTING : (Pageable.class.isAssignableFrom(type) ? IgniteQuery.Option.PAGINATION : IgniteQuery.Option.NONE);
        for (int i = 0; i < types.length - 1; ++i) {
            Class<?> tp = types[i];
            if (tp == Sort.class || tp == Pageable.class) {
                throw new AssertionError((Object)"Sort and Pageable parameters are allowed only in the last position");
            }
        }
        return option;
    }

    private static void handleQueryPart(StringBuilder sql, Part part) {
        sql.append("(");
        sql.append(part.getProperty());
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                sql.append("=?");
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                sql.append("<>?");
                break;
            }
            case GREATER_THAN: {
                sql.append(">?");
                break;
            }
            case GREATER_THAN_EQUAL: {
                sql.append(">=?");
                break;
            }
            case LESS_THAN: {
                sql.append("<?");
                break;
            }
            case LESS_THAN_EQUAL: {
                sql.append("<=?");
                break;
            }
            case IS_NOT_NULL: {
                sql.append(" IS NOT NULL");
                break;
            }
            case IS_NULL: {
                sql.append(" IS NULL");
                break;
            }
            case BETWEEN: {
                sql.append(" BETWEEN ? AND ?");
                break;
            }
            case FALSE: {
                sql.append(" = FALSE");
                break;
            }
            case TRUE: {
                sql.append(" = TRUE");
                break;
            }
            case CONTAINING: {
                sql.append(" LIKE '%' || ? || '%'");
                break;
            }
            case NOT_CONTAINING: {
                sql.append(" NOT LIKE '%' || ? || '%'");
                break;
            }
            case LIKE: {
                sql.append(" LIKE '%' || ? || '%'");
                break;
            }
            case NOT_LIKE: {
                sql.append(" NOT LIKE '%' || ? || '%'");
                break;
            }
            case STARTING_WITH: {
                sql.append(" LIKE  ? || '%'");
                break;
            }
            case ENDING_WITH: {
                sql.append(" LIKE '%' || ?");
                break;
            }
            case IN: {
                sql.append(" IN ?");
                break;
            }
            case NOT_IN: {
                sql.append(" NOT IN ?");
                break;
            }
            case REGEX: {
                sql.append(" REGEXP ?");
                break;
            }
            default: {
                throw new UnsupportedOperationException(part.getType() + " is not supported!");
            }
        }
        sql.append(")");
    }
}

