/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Bound;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.NaNUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetDictionaryRowGroupFilter {
    private final Schema schema;
    private final Expression expr;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    public ParquetDictionaryRowGroupFilter(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public ParquetDictionaryRowGroupFilter(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        Types.StructType struct = schema.asStruct();
        this.expr = Binder.bind((Types.StructType)struct, (Expression)Expressions.rewriteNot((Expression)unbound), (boolean)caseSensitive);
    }

    public boolean shouldRead(MessageType fileSchema, BlockMetaData rowGroup, DictionaryPageReadStore dictionaries) {
        return new EvalVisitor().eval(fileSchema, rowGroup, dictionaries);
    }

    private static boolean mayContainNull(ColumnChunkMetaData meta) {
        return meta.getStatistics() == null || meta.getStatistics().getNumNulls() != 0L;
    }

    private class EvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private DictionaryPageReadStore dictionaries = null;
        private Map<Integer, Set<?>> dictCache = null;
        private Map<Integer, Boolean> isFallback = null;
        private Map<Integer, Boolean> mayContainNulls = null;
        private Map<Integer, ColumnDescriptor> cols = null;
        private Map<Integer, Function<Object, Object>> conversions = null;

        private EvalVisitor() {
        }

        private boolean eval(MessageType fileSchema, BlockMetaData rowGroup, DictionaryPageReadStore dictionaryReadStore) {
            int id;
            PrimitiveType colType;
            this.dictionaries = dictionaryReadStore;
            this.dictCache = Maps.newHashMap();
            this.isFallback = Maps.newHashMap();
            this.mayContainNulls = Maps.newHashMap();
            this.cols = Maps.newHashMap();
            this.conversions = Maps.newHashMap();
            for (ColumnDescriptor desc : fileSchema.getColumns()) {
                colType = fileSchema.getType(desc.getPath()).asPrimitiveType();
                if (colType.getId() == null) continue;
                id = colType.getId().intValue();
                Type icebergType = ParquetDictionaryRowGroupFilter.this.schema.findType(id);
                this.cols.put(id, desc);
                this.conversions.put(id, ParquetConversions.converterFromParquet(colType, icebergType));
            }
            for (ColumnChunkMetaData meta : rowGroup.getColumns()) {
                colType = fileSchema.getType(meta.getPath().toArray()).asPrimitiveType();
                if (colType.getId() == null) continue;
                id = colType.getId().intValue();
                this.isFallback.put(id, ParquetUtil.hasNonDictionaryPages(meta));
                this.mayContainNulls.put(id, ParquetDictionaryRowGroupFilter.mayContainNull(meta));
            }
            return ExpressionVisitors.visitEvaluator((Expression)ParquetDictionaryRowGroupFilter.this.expr, (ExpressionVisitors.ExpressionVisitor)this);
        }

        public Boolean alwaysTrue() {
            return true;
        }

        public Boolean alwaysFalse() {
            return false;
        }

        public Boolean not(Boolean result) {
            return result == false;
        }

        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        public <T> Boolean isNull(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean notNull(BoundReference<T> ref) {
            return true;
        }

        public <T> Boolean isNaN(BoundReference<T> ref) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, this.comparatorForNaNPredicate(ref));
            return dictionary.stream().anyMatch(NaNUtil::isNaN);
        }

        public <T> Boolean notNaN(BoundReference<T> ref) {
            int id = ref.fieldId();
            if (this.mayContainNulls.get(id).booleanValue()) {
                return true;
            }
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, this.comparatorForNaNPredicate(ref));
            return !dictionary.stream().allMatch(NaNUtil::isNaN);
        }

        private <T> Comparator<T> comparatorForNaNPredicate(BoundReference<T> ref) {
            return Comparators.forType((Type.PrimitiveType)ref.type().asPrimitiveType());
        }

        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp >= 0) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp > 0) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp <= 0) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp < 0) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            return dictionary.contains(lit.value());
        }

        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            if (dictionary.size() > 1 || this.mayContainNulls.get(id).booleanValue()) {
                return true;
            }
            return !dictionary.contains(lit.value());
        }

        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            Set<T> biggerSet;
            Set<T> smallerSet;
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, ref.comparator());
            if (literalSet.size() < dictionary.size()) {
                smallerSet = literalSet;
                biggerSet = dictionary;
            } else {
                smallerSet = dictionary;
                biggerSet = literalSet;
            }
            for (T e : smallerSet) {
                if (!biggerSet.contains(e)) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, ref.comparator());
            if (dictionary.size() > literalSet.size() || this.mayContainNulls.get(id).booleanValue()) {
                return true;
            }
            return !Sets.difference(dictionary, literalSet).isEmpty();
        }

        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                if (!item.toString().startsWith(lit.value().toString())) continue;
                return true;
            }
            return false;
        }

        public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
            int id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                if (item.toString().startsWith(lit.value().toString())) continue;
                return true;
            }
            return false;
        }

        private <T> Set<T> dict(int id, Comparator<T> comparator) {
            Dictionary dict;
            Preconditions.checkNotNull((Object)this.dictionaries, (Object)"Dictionary is required");
            Set<?> cached = this.dictCache.get(id);
            if (cached != null) {
                return cached;
            }
            ColumnDescriptor col = this.cols.get(id);
            DictionaryPage page = this.dictionaries.readDictionaryPage(col);
            if (page == null) {
                throw new IllegalStateException("Failed to read required dictionary page for id: " + id);
            }
            Function<Object, Object> conversion = this.conversions.get(id);
            try {
                dict = page.getEncoding().initDictionary(col, page);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to create reader for dictionary page", new Object[0]);
            }
            TreeSet dictSet = Sets.newTreeSet(comparator);
            block10: for (int i = 0; i <= dict.getMaxId(); ++i) {
                switch (col.getPrimitiveType().getPrimitiveTypeName()) {
                    case FIXED_LEN_BYTE_ARRAY: {
                        dictSet.add(conversion.apply(dict.decodeToBinary(i)));
                        continue block10;
                    }
                    case BINARY: {
                        dictSet.add(conversion.apply(dict.decodeToBinary(i)));
                        continue block10;
                    }
                    case INT32: {
                        dictSet.add(conversion.apply(dict.decodeToInt(i)));
                        continue block10;
                    }
                    case INT64: {
                        dictSet.add(conversion.apply(dict.decodeToLong(i)));
                        continue block10;
                    }
                    case FLOAT: {
                        dictSet.add(conversion.apply(Float.valueOf(dict.decodeToFloat(i))));
                        continue block10;
                    }
                    case DOUBLE: {
                        dictSet.add(conversion.apply(dict.decodeToDouble(i)));
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot decode dictionary of type: " + col.getPrimitiveType().getPrimitiveTypeName());
                    }
                }
            }
            this.dictCache.put(id, dictSet);
            return dictSet;
        }

        public <T> Boolean handleNonReference(Bound<T> term) {
            return true;
        }
    }
}

