/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHiveCommitLocks
extends HiveTableBaseTest {
    private static HiveTableOperations spyOps = null;
    private static HiveClientPool spyClientPool = null;
    private static CachedClientPool spyCachedClientPool = null;
    private static Configuration overriddenHiveConf = new Configuration((Configuration)hiveConf);
    private static AtomicReference<IMetaStoreClient> spyClientRef = new AtomicReference();
    private static IMetaStoreClient spyClient = null;
    HiveTableOperations ops = null;
    TableMetadata metadataV1 = null;
    TableMetadata metadataV2 = null;
    long dummyLockId = 500L;
    LockResponse waitLockResponse = new LockResponse(this.dummyLockId, LockState.WAITING);
    LockResponse acquiredLockResponse = new LockResponse(this.dummyLockId, LockState.ACQUIRED);
    LockResponse notAcquiredLockResponse = new LockResponse(this.dummyLockId, LockState.NOT_ACQUIRED);

    @BeforeClass
    public static void initializeSpies() throws Exception {
        overriddenHiveConf.setLong("iceberg.hive.lock-timeout-ms", 6000L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-min-wait-ms", 50L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-max-wait-ms", 5000L);
        spyClientPool = (HiveClientPool)Mockito.spy((Object)new HiveClientPool(1, overriddenHiveConf));
        Mockito.when((Object)spyClientPool.newClient()).thenAnswer(invocation -> {
            IMetaStoreClient client = (IMetaStoreClient)Mockito.spy((Object)new HiveMetaStoreClient(hiveConf));
            spyClientRef.set(client);
            return spyClientRef.get();
        });
        spyClientPool.run(IMetaStoreClient::isLocalMetaStore);
        spyCachedClientPool = (CachedClientPool)Mockito.spy((Object)new CachedClientPool((Configuration)hiveConf, Collections.emptyMap()));
        Mockito.when((Object)spyCachedClientPool.clientPool()).thenAnswer(invocation -> spyClientPool);
        Assert.assertNotNull((Object)spyClientRef.get());
        spyClient = spyClientRef.get();
    }

    @Before
    public void before() throws Exception {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        this.ops = (HiveTableOperations)((HasTableOperations)table).operations();
        String dbName = TABLE_IDENTIFIER.namespace().level(0);
        String tableName = TABLE_IDENTIFIER.name();
        this.metadataV1 = this.ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        this.ops.refresh();
        this.metadataV2 = this.ops.current();
        Assert.assertEquals((long)2L, (long)this.ops.current().schema().columns().size());
        spyOps = (HiveTableOperations)Mockito.spy((Object)new HiveTableOperations(overriddenHiveConf, (ClientPool)spyCachedClientPool, this.ops.io(), catalog.name(), dbName, tableName));
    }

    @AfterClass
    public static void cleanup() {
        try {
            spyClientPool.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testLockAcquisitionAtFirstTime() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((HiveTableOperations)Mockito.doNothing().when((Object)spyOps)).doUnlock(Matchers.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testLockAcquisitionAfterRetries() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Matchers.eq((long)this.dummyLockId));
        ((HiveTableOperations)Mockito.doNothing().when((Object)spyOps)).doUnlock(Matchers.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testLockFailureAtFirstTime() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testLockFailureAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).checkLock(Matchers.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testLockTimeoutAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).checkLock(Matchers.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Timed out after", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testPassThroughThriftExceptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doThrow(new Throwable[]{new TException("Test Thrift Exception")}).when((Object)spyClient)).checkLock(Matchers.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", RuntimeException.class, (String)"Metastore operation failed for", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testPassThroughInterruptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Matchers.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            Thread.sleep(10L);
            return this.waitLockResponse;
        }).when((Object)spyClient)).checkLock(Matchers.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testTableLevelProcessLockBlocksConcurrentHMSRequestsForSameTable() throws Exception {
        int numConcurrentCommits = 10;
        Mockito.reset((Object[])new IMetaStoreClient[]{spyClient});
        ExecutorService executor = Executors.newFixedThreadPool(numConcurrentCommits);
        IntStream.range(0, numConcurrentCommits).forEach(i -> executor.submit(() -> {
            try {
                spyOps.doCommit(this.metadataV2, this.metadataV1);
            }
            catch (CommitFailedException commitFailedException) {
                // empty catch block
            }
        }));
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).checkLock(((Long)Matchers.any(Long.class)).longValue());
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)numConcurrentCommits))).lock((LockRequest)Matchers.any(LockRequest.class));
    }
}

