/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.junit.Assert;
import org.junit.Test;

public class TestCachedClientPool
extends HiveMetastoreTest {
    @Test
    public void testClientPoolCleaner() throws InterruptedException {
        String metastoreUri = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname, "");
        CachedClientPool clientPool = new CachedClientPool((Configuration)hiveConf, Collections.emptyMap());
        HiveClientPool clientPool1 = clientPool.clientPool();
        Assert.assertTrue((CachedClientPool.clientPoolCache().getIfPresent((Object)metastoreUri) == clientPool1 ? 1 : 0) != 0);
        TimeUnit.MILLISECONDS.sleep(EVICTION_INTERVAL - TimeUnit.SECONDS.toMillis(2L));
        HiveClientPool clientPool2 = clientPool.clientPool();
        Assert.assertTrue((clientPool1 == clientPool2 ? 1 : 0) != 0);
        TimeUnit.MILLISECONDS.sleep(EVICTION_INTERVAL + TimeUnit.SECONDS.toMillis(5L));
        Assert.assertNull((Object)CachedClientPool.clientPoolCache().getIfPresent((Object)metastoreUri));
    }
}

