/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.AccountingDate;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.AccountingEra;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.AccountingYearDivision;

public final class AccountingChronology
extends AbstractChronology
implements Serializable {
    private static final long serialVersionUID = 7291205177830286973L;
    private static final ValueRange PROLEPTIC_MONTH_RANGE_12 = ValueRange.of(-11999988L, 11999999L);
    private static final ValueRange PROLEPTIC_MONTH_RANGE_13 = ValueRange.of(-12999987L, 12999999L);
    private static final ValueRange ALIGNED_WEEK_OF_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);
    static final ValueRange DAY_OF_YEAR_RANGE = ValueRange.of(1L, 364L, 371L);
    private final DayOfWeek endsOn;
    private final boolean inLastWeek;
    private final Month end;
    private final AccountingYearDivision division;
    private final int leapWeekInMonth;
    private final transient int yearZeroDifference;
    private final transient ValueRange alignedWeekOfMonthRange;
    private final transient ValueRange dayOfMonthRange;
    private final transient int days0001ToIso1970;

    static AccountingChronology create(DayOfWeek endsOn, Month end, boolean inLastWeek, AccountingYearDivision division, int leapWeekInMonth) {
        if (endsOn == null || end == null || division == null || leapWeekInMonth == 0) {
            throw new IllegalStateException("AccountingCronology cannot be built: " + (endsOn == null ? "| ending day-of-week |" : "") + (end == null ? "| month ending in/nearest to |" : "") + (division == null ? "| how year divided |" : "") + (leapWeekInMonth == 0 ? "| leap-week month |" : "") + " not set.");
        }
        if (!division.getMonthsInYearRange().isValidValue(leapWeekInMonth)) {
            throw new IllegalStateException("Leap week cannot not be placed in non-existant month " + leapWeekInMonth + ", range is [" + division.getMonthsInYearRange() + "].");
        }
        LocalDate endingLimit = inLastWeek ? LocalDate.of(0, end, 1).with(TemporalAdjusters.lastDayOfMonth()) : LocalDate.of(0, end, 1).with(TemporalAdjusters.lastDayOfMonth()).plusDays(3L);
        LocalDate yearZeroEnd = endingLimit.with(TemporalAdjusters.previousOrSame(endsOn));
        int yearZeroDifference = (int)yearZeroEnd.until(endingLimit, ChronoUnit.DAYS);
        int longestMonthLength = 0;
        int shortestMonthLength = Integer.MAX_VALUE;
        int month = 1;
        while ((long)month <= division.getMonthsInYearRange().getMaximum()) {
            int monthLength = division.getWeeksInMonth(month);
            shortestMonthLength = Math.min(shortestMonthLength, monthLength);
            longestMonthLength = Math.max(longestMonthLength, monthLength + (month == leapWeekInMonth ? 1 : 0));
            ++month;
        }
        ValueRange alignedWeekOfMonthRange = ValueRange.of(1L, shortestMonthLength, longestMonthLength);
        ValueRange dayOfMonthRange = ValueRange.of(1L, shortestMonthLength * 7, longestMonthLength * 7);
        int daysToEpoch = Math.toIntExact(0L - yearZeroEnd.plusDays(1L).toEpochDay());
        return new AccountingChronology(endsOn, end, inLastWeek, division, leapWeekInMonth, yearZeroDifference, alignedWeekOfMonthRange, dayOfMonthRange, daysToEpoch);
    }

    private AccountingChronology(DayOfWeek endsOn, Month end, boolean inLastWeek, AccountingYearDivision division, int leapWeekInMonth, int yearZeroDifference, ValueRange alignedWeekOfMonthRange, ValueRange dayOfMonthRange, int daysToEpoch) {
        this.endsOn = endsOn;
        this.end = end;
        this.inLastWeek = inLastWeek;
        this.division = division;
        this.leapWeekInMonth = leapWeekInMonth;
        this.yearZeroDifference = yearZeroDifference;
        this.alignedWeekOfMonthRange = alignedWeekOfMonthRange;
        this.dayOfMonthRange = dayOfMonthRange;
        this.days0001ToIso1970 = daysToEpoch;
    }

    private Object readResolve() {
        return AccountingChronology.create(this.endsOn, this.end, this.inLastWeek, this.getDivision(), this.leapWeekInMonth);
    }

    AccountingYearDivision getDivision() {
        return this.division;
    }

    int getLeapWeekInMonth() {
        return this.leapWeekInMonth;
    }

    int getDays0001ToIso1970() {
        return this.days0001ToIso1970;
    }

    @Override
    public String getId() {
        return "Accounting";
    }

    @Override
    public String getCalendarType() {
        return null;
    }

    @Override
    public AccountingDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public AccountingDate date(int prolepticYear, int month, int dayOfMonth) {
        return AccountingDate.of(this, prolepticYear, month, dayOfMonth);
    }

    @Override
    public AccountingDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public AccountingDate dateYearDay(int prolepticYear, int dayOfYear) {
        return AccountingDate.ofYearDay(this, prolepticYear, dayOfYear);
    }

    @Override
    public AccountingDate dateEpochDay(long epochDay) {
        return AccountingDate.ofEpochDay(this, epochDay);
    }

    @Override
    public AccountingDate dateNow() {
        return AccountingDate.now(this);
    }

    @Override
    public AccountingDate dateNow(ZoneId zone) {
        return AccountingDate.now(this, zone);
    }

    @Override
    public AccountingDate dateNow(Clock clock) {
        return AccountingDate.now(this, clock);
    }

    @Override
    public AccountingDate date(TemporalAccessor temporal) {
        return AccountingDate.from(this, temporal);
    }

    public ChronoLocalDateTime<AccountingDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<AccountingDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<AccountingDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return Math.floorMod(prolepticYear + this.getISOLeapYearCount(prolepticYear) + (long)this.yearZeroDifference, 7L) == 0L || Math.floorMod(prolepticYear + this.getISOLeapYearCount(prolepticYear + 1L) + (long)this.yearZeroDifference, 7L) == 0L;
    }

    private long getISOLeapYearCount(long prolepticYear) {
        long offsetYear = prolepticYear - (long)(this.end == Month.JANUARY ? 1 : 0) - 1L;
        return Math.floorDiv(offsetYear, 4L) - Math.floorDiv(offsetYear, 100L) + Math.floorDiv(offsetYear, 400L) + (long)(this.end == Month.JANUARY ? 1 : 0);
    }

    long previousLeapYears(long prolepticYear) {
        return Math.floorDiv(prolepticYear - 1L + this.getISOLeapYearCount(prolepticYear) + (long)this.yearZeroDifference, 7L);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof AccountingEra)) {
            throw new ClassCastException("Era must be AccountingEra");
        }
        return era == AccountingEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public AccountingEra eraOf(int era) {
        return AccountingEra.of(era);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(AccountingEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        switch (field) {
            case ALIGNED_WEEK_OF_MONTH: {
                return this.alignedWeekOfMonthRange;
            }
            case ALIGNED_WEEK_OF_YEAR: {
                return ALIGNED_WEEK_OF_YEAR_RANGE;
            }
            case DAY_OF_MONTH: {
                return this.dayOfMonthRange;
            }
            case DAY_OF_YEAR: {
                return DAY_OF_YEAR_RANGE;
            }
            case MONTH_OF_YEAR: {
                return this.getDivision().getMonthsInYearRange();
            }
            case PROLEPTIC_MONTH: {
                return this.getDivision() == AccountingYearDivision.THIRTEEN_EVEN_MONTHS_OF_4_WEEKS ? PROLEPTIC_MONTH_RANGE_13 : PROLEPTIC_MONTH_RANGE_12;
            }
        }
        return field.range();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AccountingChronology) {
            AccountingChronology other = (AccountingChronology)obj;
            return this.endsOn == other.endsOn && this.inLastWeek == other.inLastWeek && this.end == other.end && this.getDivision() == other.getDivision() && this.leapWeekInMonth == other.leapWeekInMonth;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + this.endsOn.hashCode();
        result = 31 * result + (this.inLastWeek ? 1231 : 1237);
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.leapWeekInMonth;
        result = 31 * result + this.getDivision().hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder(30);
        bld.append(this.getId()).append(" calendar ends on ").append(this.endsOn).append(this.inLastWeek ? " in last week of " : " nearest end of ").append(this.end).append(", year divided in ").append((Object)this.getDivision()).append(" with leap-week in month ").append(this.leapWeekInMonth);
        return bld.toString();
    }
}

