/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata;

import java.util.Set;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.iceberg.shaded.org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.iceberg.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.iceberg.shaded.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.EncryptedColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.IntColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.LongColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;
import org.apache.yetus.audience.InterfaceAudience;

public abstract class ColumnChunkMetaData {
    protected int rowGroupOrdinal = -1;
    EncodingStats encodingStats;
    ColumnChunkProperties properties;
    private IndexReference columnIndexReference;
    private IndexReference offsetIndexReference;
    private long bloomFilterOffset = -1L;

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, type, codec, null, encodings, (Statistics)new BooleanStatistics(), firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, type, codec, null, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    @Deprecated
    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        return ColumnChunkMetaData.get(path, (PrimitiveType)Types.optional(type).named("fake_type"), codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    public static ColumnChunkMetaData get(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        if (ColumnChunkMetaData.positiveLongFitsInAnInt(firstDataPage) && ColumnChunkMetaData.positiveLongFitsInAnInt(dictionaryPageOffset) && ColumnChunkMetaData.positiveLongFitsInAnInt(valueCount) && ColumnChunkMetaData.positiveLongFitsInAnInt(totalSize) && ColumnChunkMetaData.positiveLongFitsInAnInt(totalUncompressedSize)) {
            return new IntColumnChunkMetaData(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
        }
        return new LongColumnChunkMetaData(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    public static ColumnChunkMetaData getWithEncryptedMetadata(ParquetMetadataConverter parquetMetadataConverter, ColumnPath path, PrimitiveType type, byte[] encryptedMetadata, byte[] columnKeyMetadata, InternalFileDecryptor fileDecryptor, int rowGroupOrdinal, int columnOrdinal, String createdBy) {
        return new EncryptedColumnChunkMetaData(parquetMetadataConverter, path, type, encryptedMetadata, columnKeyMetadata, fileDecryptor, rowGroupOrdinal, columnOrdinal, createdBy);
    }

    public void setRowGroupOrdinal(int rowGroupOrdinal) {
        this.rowGroupOrdinal = rowGroupOrdinal;
    }

    public int getRowGroupOrdinal() {
        return this.rowGroupOrdinal;
    }

    public long getStartingPos() {
        this.decryptIfNeeded();
        long dictionaryPageOffset = this.getDictionaryPageOffset();
        long firstDataPageOffset = this.getFirstDataPageOffset();
        if (dictionaryPageOffset > 0L && dictionaryPageOffset < firstDataPageOffset) {
            return dictionaryPageOffset;
        }
        return firstDataPageOffset;
    }

    protected static boolean positiveLongFitsInAnInt(long value) {
        return value >= 0L && value + Integer.MIN_VALUE <= Integer.MAX_VALUE;
    }

    protected ColumnChunkMetaData(ColumnChunkProperties columnChunkProperties) {
        this(null, columnChunkProperties);
    }

    protected ColumnChunkMetaData(EncodingStats encodingStats, ColumnChunkProperties columnChunkProperties) {
        this.encodingStats = encodingStats;
        this.properties = columnChunkProperties;
    }

    protected void decryptIfNeeded() {
    }

    public CompressionCodecName getCodec() {
        this.decryptIfNeeded();
        return this.properties.getCodec();
    }

    public ColumnPath getPath() {
        return this.properties.getPath();
    }

    @Deprecated
    public PrimitiveType.PrimitiveTypeName getType() {
        this.decryptIfNeeded();
        return this.properties.getType();
    }

    public PrimitiveType getPrimitiveType() {
        this.decryptIfNeeded();
        return this.properties.getPrimitiveType();
    }

    public abstract long getFirstDataPageOffset();

    public abstract long getDictionaryPageOffset();

    public abstract long getValueCount();

    public abstract long getTotalUncompressedSize();

    public abstract long getTotalSize();

    public abstract Statistics getStatistics();

    @InterfaceAudience.Private
    public IndexReference getColumnIndexReference() {
        this.decryptIfNeeded();
        return this.columnIndexReference;
    }

    @InterfaceAudience.Private
    public void setColumnIndexReference(IndexReference indexReference) {
        this.columnIndexReference = indexReference;
    }

    @InterfaceAudience.Private
    public IndexReference getOffsetIndexReference() {
        this.decryptIfNeeded();
        return this.offsetIndexReference;
    }

    @InterfaceAudience.Private
    public void setOffsetIndexReference(IndexReference offsetIndexReference) {
        this.offsetIndexReference = offsetIndexReference;
    }

    @InterfaceAudience.Private
    public void setBloomFilterOffset(long bloomFilterOffset) {
        this.bloomFilterOffset = bloomFilterOffset;
    }

    @InterfaceAudience.Private
    public long getBloomFilterOffset() {
        this.decryptIfNeeded();
        return this.bloomFilterOffset;
    }

    public Set<Encoding> getEncodings() {
        this.decryptIfNeeded();
        return this.properties.getEncodings();
    }

    public EncodingStats getEncodingStats() {
        this.decryptIfNeeded();
        return this.encodingStats;
    }

    public String toString() {
        this.decryptIfNeeded();
        return "ColumnMetaData{" + this.properties.toString() + ", " + this.getFirstDataPageOffset() + "}";
    }

    public boolean hasDictionaryPage() {
        EncodingStats stats = this.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && stats.hasDictionaryEncodedPages();
        }
        Set<Encoding> encodings = this.getEncodings();
        return encodings.contains((Object)Encoding.PLAIN_DICTIONARY) || encodings.contains((Object)Encoding.RLE_DICTIONARY);
    }
}

