/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.io.airlift.compress.Compressor;
import org.apache.iceberg.shaded.io.airlift.compress.Decompressor;
import org.apache.iceberg.shaded.org.apache.orc.CompressionCodec;
import org.apache.iceberg.shaded.org.apache.orc.CompressionKind;
import org.apache.iceberg.shaded.org.apache.orc.impl.OrcCodecPool;

public class AircompressorCodec
implements CompressionCodec {
    private final CompressionKind kind;
    private final Compressor compressor;
    private final Decompressor decompressor;
    private static final ThreadLocal<byte[]> threadBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return null;
        }
    };
    private static final CompressionCodec.Options NULL_OPTION = new CompressionCodec.Options(){

        @Override
        public CompressionCodec.Options copy() {
            return this;
        }

        @Override
        public CompressionCodec.Options setSpeed(CompressionCodec.SpeedModifier newValue) {
            return this;
        }

        @Override
        public CompressionCodec.Options setData(CompressionCodec.DataKind newValue) {
            return this;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass();
        }

        public int hashCode() {
            return 0;
        }
    };

    AircompressorCodec(CompressionKind kind, Compressor compressor, Decompressor decompressor) {
        this.kind = kind;
        this.compressor = compressor;
        this.decompressor = decompressor;
    }

    protected static byte[] getBuffer(int size) {
        byte[] result = threadBuffer.get();
        if (result == null || result.length < size || result.length > size * 2) {
            result = new byte[size];
            threadBuffer.set(result);
        }
        return result;
    }

    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow, CompressionCodec.Options options) {
        int inBytes = in.remaining();
        byte[] compressed = AircompressorCodec.getBuffer(this.compressor.maxCompressedLength(inBytes));
        int outBytes = this.compressor.compress(in.array(), in.arrayOffset() + in.position(), inBytes, compressed, 0, compressed.length);
        if (outBytes < inBytes) {
            int remaining = out.remaining();
            if (remaining >= outBytes) {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                out.position(out.position() + outBytes);
            } else {
                System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                out.position(out.limit());
                System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                overflow.position(outBytes - remaining);
            }
            return true;
        }
        return false;
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        int inOffset = in.position();
        int uncompressLen = this.decompressor.decompress(in.array(), in.arrayOffset() + inOffset, in.limit() - inOffset, out.array(), out.arrayOffset() + out.position(), out.remaining());
        out.position(uncompressLen + out.position());
        out.flip();
    }

    @Override
    public CompressionCodec.Options getDefaultOptions() {
        return NULL_OPTION;
    }

    @Override
    public void reset() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public CompressionKind getKind() {
        return this.kind;
    }

    @Override
    public void close() {
        OrcCodecPool.returnCodec(this.kind, this);
    }
}

