/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.parquet.TripleWriter;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnWriteStore;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;

public abstract class ColumnWriter<T>
implements TripleWriter<T> {
    private final ColumnDescriptor desc;
    private final int maxDefinitionLevel;
    private org.apache.iceberg.shaded.org.apache.parquet.column.ColumnWriter columnWriter = null;

    static <T> ColumnWriter<T> newWriter(ColumnDescriptor desc) {
        switch (desc.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new ColumnWriter<Boolean>(desc){

                    @Override
                    public void write(int rl, Boolean value) {
                        this.writeBoolean(rl, value);
                    }
                };
            }
            case INT32: {
                return new ColumnWriter<Integer>(desc){

                    @Override
                    public void write(int rl, Integer value) {
                        this.writeInteger(rl, value);
                    }
                };
            }
            case INT64: {
                return new ColumnWriter<Long>(desc){

                    @Override
                    public void write(int rl, Long value) {
                        this.writeLong(rl, value);
                    }
                };
            }
            case FLOAT: {
                return new ColumnWriter<Float>(desc){

                    @Override
                    public void write(int rl, Float value) {
                        this.writeFloat(rl, value.floatValue());
                    }
                };
            }
            case DOUBLE: {
                return new ColumnWriter<Double>(desc){

                    @Override
                    public void write(int rl, Double value) {
                        this.writeDouble(rl, value);
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return new ColumnWriter<Binary>(desc){

                    @Override
                    public void write(int rl, Binary value) {
                        this.writeBinary(rl, value);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + (Object)((Object)desc.getPrimitiveType().getPrimitiveTypeName()));
    }

    private ColumnWriter(ColumnDescriptor desc) {
        this.desc = desc;
        this.maxDefinitionLevel = desc.getMaxDefinitionLevel();
    }

    public void setColumnStore(ColumnWriteStore columnStore) {
        this.columnWriter = columnStore.getColumnWriter(this.desc);
    }

    @Override
    public void writeBoolean(int rl, boolean value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeInteger(int rl, int value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeLong(int rl, long value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeFloat(int rl, float value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeDouble(int rl, double value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeBinary(int rl, Binary value) {
        this.columnWriter.write(value, rl, this.maxDefinitionLevel);
    }

    @Override
    public void writeNull(int rl, int dl) {
        this.columnWriter.writeNull(rl, dl);
    }
}

