/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.shaded.org.apache.orc.RecordReader;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.iceberg.util.Pair;

public class VectorizedRowBatchIterator
implements CloseableIterator<Pair<VectorizedRowBatch, Long>> {
    private final String fileLocation;
    private final RecordReader rows;
    private final VectorizedRowBatch batch;
    private boolean advanced = false;
    private long batchOffsetInFile = 0L;

    VectorizedRowBatchIterator(String fileLocation, TypeDescription schema, RecordReader rows, int recordsPerBatch) {
        this.fileLocation = fileLocation;
        this.rows = rows;
        this.batch = schema.createRowBatch(recordsPerBatch);
    }

    @Override
    public void close() throws IOException {
        this.rows.close();
    }

    private void advance() {
        if (!this.advanced) {
            try {
                this.batchOffsetInFile = this.rows.getRowNumber();
                this.rows.nextBatch(this.batch);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe, "Problem reading ORC file %s", this.fileLocation);
            }
            this.advanced = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.batch.size > 0;
    }

    @Override
    public Pair<VectorizedRowBatch, Long> next() {
        this.advance();
        this.advanced = false;
        return Pair.of(this.batch, this.batchOffsetInFile);
    }
}

