/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum RowLevelOperationMode {
    COPY_ON_WRITE,
    MERGE_ON_READ;


    public static RowLevelOperationMode fromName(String modeName) {
        Preconditions.checkArgument(modeName != null, "Mode name is null");
        if ("copy-on-write".equalsIgnoreCase(modeName)) {
            return COPY_ON_WRITE;
        }
        if ("merge-on-read".equalsIgnoreCase(modeName)) {
            return MERGE_ON_READ;
        }
        throw new IllegalArgumentException("Unknown row-level operation mode: " + modeName);
    }
}

