/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import java.net.URI;
import java.util.Set;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

class EcsURI {
    private static final Set<String> VALID_SCHEME = ImmutableSet.of((Object)"ecs", (Object)"s3", (Object)"s3a", (Object)"s3n");
    private final String location;
    private final String bucket;
    private final String name;

    EcsURI(String location) {
        Preconditions.checkNotNull((Object)(location == null ? 1 : 0), (String)"Location %s can not be null", (Object)location);
        this.location = location;
        URI uri = URI.create(location);
        ValidationException.check((boolean)VALID_SCHEME.contains(uri.getScheme().toLowerCase()), (String)"Invalid ecs location: %s", (Object[])new Object[]{location});
        this.bucket = uri.getHost();
        this.name = uri.getPath().replaceAll("^/*", "");
    }

    EcsURI(String bucket, String name) {
        this.bucket = bucket;
        this.name = name.replaceAll("^/*", "");
        this.location = String.format("ecs://%s/%s", bucket, name);
    }

    public String bucket() {
        return this.bucket;
    }

    public String name() {
        return this.name;
    }

    public String location() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }
}

