/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Objects;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.transforms.Transform;

public class SortField
implements Serializable {
    private final Transform<?, ?> transform;
    private final int sourceId;
    private final SortDirection direction;
    private final NullOrder nullOrder;

    SortField(Transform<?, ?> transform, int sourceId, SortDirection direction, NullOrder nullOrder) {
        this.transform = transform;
        this.sourceId = sourceId;
        this.direction = direction;
        this.nullOrder = nullOrder;
    }

    public <S, T> Transform<S, T> transform() {
        return this.transform;
    }

    public int sourceId() {
        return this.sourceId;
    }

    public SortDirection direction() {
        return this.direction;
    }

    public NullOrder nullOrder() {
        return this.nullOrder;
    }

    public boolean satisfies(SortField other) {
        if (Objects.equals(this, other)) {
            return true;
        }
        if (this.sourceId != other.sourceId || this.direction != other.direction || this.nullOrder != other.nullOrder) {
            return false;
        }
        return this.transform.satisfiesOrderOf(other.transform);
    }

    public String toString() {
        return this.transform + "(" + this.sourceId + ") " + (Object)((Object)this.direction) + " " + (Object)((Object)this.nullOrder);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SortField that = (SortField)other;
        return this.transform.equals(that.transform) && this.sourceId == that.sourceId && this.direction == that.direction && this.nullOrder == that.nullOrder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transform, this.sourceId, this.direction, this.nullOrder});
    }
}

