/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.timeline.service.handlers.MarkerHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerBasedEarlyConflictDetectionRunnable
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(MarkerBasedEarlyConflictDetectionRunnable.class);
    private MarkerHandler markerHandler;
    private String markerDir;
    private String basePath;
    private FileSystem fs;
    private AtomicBoolean hasConflict;
    private long maxAllowableHeartbeatIntervalInMs;
    private Set<HoodieInstant> completedCommits;
    private final boolean checkCommitConflict;

    public MarkerBasedEarlyConflictDetectionRunnable(AtomicBoolean hasConflict, MarkerHandler markerHandler, String markerDir, String basePath, FileSystem fileSystem, long maxAllowableHeartbeatIntervalInMs, Set<HoodieInstant> completedCommits, boolean checkCommitConflict) {
        this.markerHandler = markerHandler;
        this.markerDir = markerDir;
        this.basePath = basePath;
        this.fs = fileSystem;
        this.hasConflict = hasConflict;
        this.maxAllowableHeartbeatIntervalInMs = maxAllowableHeartbeatIntervalInMs;
        this.completedCommits = completedCommits;
        this.checkCommitConflict = checkCommitConflict;
    }

    @Override
    public void run() {
        if (this.hasConflict.get()) {
            return;
        }
        try {
            Set<String> pendingMarkers = this.markerHandler.getPendingMarkersToProcess(this.markerDir);
            if (!this.fs.exists(new Path(this.markerDir)) && pendingMarkers.isEmpty()) {
                return;
            }
            HoodieTimer timer = HoodieTimer.start();
            HashSet<String> currentInstantAllMarkers = new HashSet<String>();
            currentInstantAllMarkers.addAll(this.markerHandler.getAllMarkers(this.markerDir));
            currentInstantAllMarkers.addAll(pendingMarkers);
            Path tempPath = new Path(this.basePath + "/" + ".hoodie/.temp");
            List instants = MarkerUtils.getAllMarkerDir((Path)tempPath, (FileSystem)this.fs);
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(new Configuration()).setBasePath(this.basePath).setLoadActiveTimelineOnLoad(true).build();
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            List candidate = MarkerUtils.getCandidateInstants((HoodieActiveTimeline)activeTimeline, (List)instants, (String)MarkerUtils.markerDirToInstantTime((String)this.markerDir), (long)this.maxAllowableHeartbeatIntervalInMs, (FileSystem)this.fs, (String)this.basePath);
            Set tableMarkers = candidate.stream().flatMap(instant -> MarkerUtils.readTimelineServerBasedMarkersFromFileSystem((String)instant, (FileSystem)this.fs, (HoodieEngineContext)new HoodieLocalEngineContext(new Configuration()), (int)100).values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
            Set currentFileIDs = currentInstantAllMarkers.stream().map(MarkerUtils::makerToPartitionAndFileID).collect(Collectors.toSet());
            Set tableFilesIDs = tableMarkers.stream().map(MarkerUtils::makerToPartitionAndFileID).collect(Collectors.toSet());
            currentFileIDs.retainAll(tableFilesIDs);
            if (!currentFileIDs.isEmpty() || this.checkCommitConflict && MarkerUtils.hasCommitConflict((HoodieActiveTimeline)activeTimeline, currentInstantAllMarkers.stream().map(MarkerUtils::makerToPartitionAndFileID).collect(Collectors.toSet()), this.completedCommits)) {
                LOG.warn((Object)("Conflict writing detected based on markers!\nConflict markers: " + currentInstantAllMarkers + "\nTable markers: " + tableMarkers));
                this.hasConflict.compareAndSet(false, true);
            }
            LOG.info((Object)("Finish batching marker-based conflict detection in " + timer.endTimer() + " ms"));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException occurs during checking marker conflict");
        }
    }
}

