/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false, false, true, true),
    HDFS("hdfs", true, false, true, false),
    AFS("afs", true, null, null, null),
    MAPRFS("maprfs", true, null, null, null),
    IGNITE("igfs", true, null, null, null),
    S3A("s3a", false, true, null, true),
    S3("s3", false, true, null, true),
    GCS("gs", false, true, null, true),
    WASB("wasb", false, null, null, null),
    WASBS("wasbs", false, null, null, null),
    ADL("adl", false, null, null, null),
    ABFS("abfs", false, null, null, null),
    ABFSS("abfss", false, null, null, null),
    OSS("oss", false, null, null, null),
    VIEWFS("viewfs", true, null, true, null),
    ALLUXIO("alluxio", false, null, null, null),
    COSN("cosn", false, null, null, null),
    CHDFS("ofs", true, null, null, null),
    GOOSEFS("gfs", false, null, null, null),
    DBFS("dbfs", false, null, null, null),
    COS("cos", false, null, null, null),
    OBS("obs", false, null, null, null),
    KS3("ks3", false, null, null, null),
    NOS("nos", false, null, null, null),
    JFS("jfs", true, null, null, null),
    BOS("bos", false, null, null, null),
    OCI("oci", false, null, null, null),
    TOS("tos", false, null, null, null),
    CFS("cfs", true, null, null, null),
    DFS("dfs", true, false, true, null),
    HOPSFS("hopsfs", false, false, true, null);

    private String scheme;
    private boolean supportsAppend;
    private Boolean isWriteTransactional;
    private Boolean supportAtomicCreation;
    private Boolean listStatusFriendly;

    private StorageSchemes(String scheme, boolean supportsAppend, Boolean isWriteTransactional, Boolean supportAtomicCreation, Boolean listStatusFriendly) {
        this.scheme = scheme;
        this.supportsAppend = supportsAppend;
        this.isWriteTransactional = isWriteTransactional;
        this.supportAtomicCreation = supportAtomicCreation;
        this.listStatusFriendly = listStatusFriendly;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public boolean isWriteTransactional() {
        return this.isWriteTransactional != null && this.isWriteTransactional != false;
    }

    public boolean isAtomicCreationSupported() {
        return this.supportAtomicCreation != null && this.supportAtomicCreation != false;
    }

    public boolean getListStatusFriendly() {
        return this.listStatusFriendly != null && this.listStatusFriendly != false;
    }

    public static boolean isSchemeSupported(String scheme) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme));
    }

    public static boolean isAppendSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.supportsAppend() && s.scheme.equals(scheme));
    }

    public static boolean isWriteTransactional(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isWriteTransactional() && s.scheme.equals(scheme));
    }

    public static boolean isAtomicCreationSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isAtomicCreationSupported() && s.scheme.equals(scheme));
    }

    public static boolean isListStatusFriendly(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getListStatusFriendly() && s.scheme.equals(scheme));
    }
}

