/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.io.Serializable;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.storage.StoragePath;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public class StoragePathInfo
implements Serializable,
Comparable<StoragePathInfo> {
    private final StoragePath path;
    private final long length;
    private final boolean isDirectory;
    private final short blockReplication;
    private final long blockSize;
    private final long modificationTime;

    public StoragePathInfo(StoragePath path, long length, boolean isDirectory, short blockReplication, long blockSize, long modificationTime) {
        this.path = path;
        this.length = length;
        this.isDirectory = isDirectory;
        this.blockReplication = blockReplication;
        this.blockSize = blockSize;
        this.modificationTime = modificationTime;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public StoragePath getPath() {
        return this.path;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public long getLength() {
        return this.length;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public boolean isFile() {
        return !this.isDirectory;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public short getBlockReplication() {
        return this.blockReplication;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public long getBlockSize() {
        return this.blockSize;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public int compareTo(StoragePathInfo o) {
        return this.getPath().compareTo(o.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoragePathInfo that = (StoragePathInfo)o;
        return this.getPath().equals(that.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return "StoragePathInfo{path=" + this.path + ", length=" + this.length + ", isDirectory=" + this.isDirectory + ", blockReplication=" + this.blockReplication + ", blockSize=" + this.blockSize + ", modificationTime=" + this.modificationTime + '}';
    }
}

