/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieHBaseKVComparator;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileUtils
extends FileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HFileUtils.class);
    private static final int DEFAULT_BLOCK_SIZE_FOR_LOG_FILE = 0x100000;

    public static Compression.Algorithm getHFileCompressionAlgorithm(Map<String, String> paramsMap) {
        String algoName = paramsMap.get(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key());
        if (StringUtils.isNullOrEmpty((String)algoName)) {
            return Compression.Algorithm.GZ;
        }
        return Compression.Algorithm.valueOf((String)algoName.toUpperCase());
    }

    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath, Schema schema) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    public Map<String, String> readFooter(HoodieStorage storage, boolean required, StoragePath filePath, String ... footerNames) {
        throw new UnsupportedOperationException("HFileUtils does not support readFooter");
    }

    public long getRowCount(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getRowCount");
    }

    public Set<String> filterRowKeys(HoodieStorage storage, StoragePath filePath, Set<String> filter) {
        throw new UnsupportedOperationException("HFileUtils does not support filterRowKeys");
    }

    public List<HoodieKey> fetchHoodieKeys(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("HFileUtils does not support getHoodieKeyIterator");
    }

    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getHoodieKeyIterator");
    }

    public List<HoodieKey> fetchHoodieKeys(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema readAvroSchema(HoodieStorage storage, StoragePath filePath) {
        LOG.info("Reading schema from {}", (Object)filePath);
        try (HoodieFileReader fileReader = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, filePath);){
            Schema schema = fileReader.getSchema();
            return schema;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read schema from HFile", e);
        }
    }

    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage storage, StoragePath filePath, List<String> columnList) {
        throw new UnsupportedOperationException("Reading column statistics from metadata is not supported for HFile format yet");
    }

    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.HFILE;
    }

    public void writeMetaFile(HoodieStorage storage, StoragePath filePath, Properties props) throws IOException {
        throw new UnsupportedOperationException("HFileUtils does not support writeMetaFile");
    }

    public byte[] serializeRecordsToLogBlock(HoodieStorage storage, List<HoodieRecord> records, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        Compression.Algorithm compressionAlgorithm = HFileUtils.getHFileCompressionAlgorithm(paramsMap);
        HFileContext context = new HFileContextBuilder().withBlockSize(0x100000).withCompression(compressionAlgorithm).withCellComparator((CellComparator)new HoodieHBaseKVComparator()).build();
        Configuration conf = (Configuration)storage.getConf().unwrapAs(Configuration.class);
        CacheConfig cacheConfig = new CacheConfig(conf);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FSDataOutputStream ostream = new FSDataOutputStream((OutputStream)baos, null);
        boolean useIntegerKey = !HFileUtils.getRecordKey(records.get(0), readerSchema, keyFieldName).isPresent();
        int keyWidth = useIntegerKey ? (int)Math.ceil(Math.log(records.size())) + 1 : -1;
        TreeMap<String, List> sortedRecordsMap = new TreeMap<String, List>();
        Iterator<HoodieRecord> itr = records.iterator();
        int id = 0;
        while (itr.hasNext()) {
            HoodieRecord record = itr.next();
            String recordKey2 = useIntegerKey ? String.format("%" + keyWidth + "s", id++) : (String)HFileUtils.getRecordKey(record, readerSchema, keyFieldName).get();
            byte[] recordBytes = HFileUtils.serializeRecord(record, writerSchema, keyFieldName);
            List recordBytesList2 = sortedRecordsMap.getOrDefault(recordKey2, new ArrayList());
            recordBytesList2.add(recordBytes);
            sortedRecordsMap.put(recordKey2, recordBytesList2);
        }
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConfig).withOutputStream(ostream).withFileContext(context).create();
        sortedRecordsMap.forEach((recordKey, recordBytesList) -> {
            for (byte[] recordBytes : recordBytesList) {
                try {
                    KeyValue kv = new KeyValue(recordKey.getBytes(), null, null, recordBytes);
                    writer.append((Cell)kv);
                }
                catch (IOException e) {
                    throw new HoodieIOException("IOException serializing records", e);
                }
            }
        });
        writer.appendFileInfo(StringUtils.getUTF8Bytes((String)"schema"), StringUtils.getUTF8Bytes((String)readerSchema.toString()));
        writer.close();
        ostream.flush();
        ostream.close();
        return baos.toByteArray();
    }

    private static Option<String> getRecordKey(HoodieRecord record, Schema readerSchema, String keyFieldName) {
        return Option.ofNullable((Object)record.getRecordKey(readerSchema, keyFieldName));
    }

    private static byte[] serializeRecord(HoodieRecord<?> record, Schema schema, String keyFieldName) throws IOException {
        Option keyField = Option.ofNullable((Object)schema.getField(keyFieldName));
        if (keyField.isPresent()) {
            record.truncateRecordKey(schema, new Properties(), ((Schema.Field)keyField.get()).name());
        }
        return (byte[])HoodieAvroUtils.recordToBytes(record, (Schema)schema).get();
    }
}

