/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieSeekingFileReader;

public abstract class HoodieAvroHFileReaderImplBase
extends HoodieAvroFileReader
implements HoodieSeekingFileReader<IndexedRecord> {
    public static final String SCHEMA_KEY = "schema";
    public static final String KEY_BLOOM_FILTER_META_BLOCK = "bloomFilter";
    public static final String KEY_BLOOM_FILTER_TYPE_CODE = "bloomFilterTypeCode";
    public static final String KEY_FIELD_NAME = "key";
    public static final String KEY_MIN_RECORD = "minRecordKey";
    public static final String KEY_MAX_RECORD = "maxRecordKey";

    public static List<IndexedRecord> readAllRecords(HoodieAvroFileReader reader) throws IOException {
        Schema schema = reader.getSchema();
        return CollectionUtils.toStream(reader.getIndexedRecordIterator(schema)).collect(Collectors.toList());
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReaderImplBase reader, List<String> keys) throws IOException {
        return HoodieAvroHFileReaderImplBase.readRecords(reader, keys, reader.getSchema());
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReaderImplBase reader, List<String> keys, Schema schema) throws IOException {
        Collections.sort(keys);
        return CollectionUtils.toStream(reader.getIndexedRecordsByKeysIterator(keys, schema)).collect(Collectors.toList());
    }

    public abstract ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> var1, Schema var2) throws IOException;

    public abstract ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> var1, Schema var2) throws IOException;

    protected static GenericRecord deserialize(byte[] keyBytes, byte[] valueBytes, Schema writerSchema, Schema readerSchema) throws IOException {
        return HoodieAvroHFileReaderImplBase.deserialize(keyBytes, 0, keyBytes.length, valueBytes, 0, valueBytes.length, writerSchema, readerSchema);
    }

    protected static GenericRecord deserialize(byte[] keyBytes, int keyOffset, int keyLength, byte[] valueBytes, int valueOffset, int valueLength, Schema writerSchema, Schema readerSchema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(valueBytes, valueOffset, valueLength, writerSchema, readerSchema);
        HoodieAvroHFileReaderImplBase.getKeySchema(readerSchema).ifPresent(keyFieldSchema -> {
            Object keyObject = record.get(keyFieldSchema.pos());
            if (keyObject != null && keyObject.toString().isEmpty()) {
                record.put(keyFieldSchema.pos(), (Object)StringUtils.fromUTF8Bytes((byte[])keyBytes, (int)keyOffset, (int)keyLength));
            }
        });
        return record;
    }

    private static Option<Schema.Field> getKeySchema(Schema schema) {
        return Option.ofNullable((Object)schema.getField(KEY_FIELD_NAME));
    }
}

