/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.http.client.HttpResponseException;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityBasedFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityBasedFileSystemView.class);
    private final SyncableFileSystemView preferredView;
    private final SyncableFileSystemView secondaryView;
    private boolean errorOnPreferredView;

    public PriorityBasedFileSystemView(SyncableFileSystemView preferredView, SyncableFileSystemView secondaryView) {
        this.preferredView = preferredView;
        this.secondaryView = secondaryView;
        this.errorOnPreferredView = false;
    }

    private <R> R execute(Functions.Function0<R> preferredFunction, Functions.Function0<R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply();
        }
        try {
            return preferredFunction.apply();
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply();
        }
    }

    private <T1, R> R execute(T1 val, Functions.Function1<T1, R> preferredFunction, Functions.Function1<T1, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val);
        }
        try {
            return preferredFunction.apply(val);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val);
        }
    }

    private <T1, T2, R> R execute(T1 val, T2 val2, Functions.Function2<T1, T2, R> preferredFunction, Functions.Function2<T1, T2, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2);
        }
        try {
            return preferredFunction.apply(val, val2);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2);
        }
    }

    private <T1, T2, T3, R> R execute(T1 val, T2 val2, T3 val3, Functions.Function3<T1, T2, T3, R> preferredFunction, Functions.Function3<T1, T2, T3, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2, val3);
        }
        try {
            return preferredFunction.apply(val, val2, val3);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2, val3);
        }
    }

    private void handleRuntimeException(RuntimeException re) {
        if (re.getCause() instanceof HttpResponseException && ((HttpResponseException)re.getCause()).getStatusCode() == 400) {
            LOG.warn("Got error running preferred function. Likely due to another concurrent writer in progress. Trying secondary");
        } else {
            LOG.error("Got error running preferred function. Trying secondary", (Throwable)re);
        }
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestBaseFiles, this.secondaryView::getLatestBaseFiles);
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles() {
        return this.execute(this.preferredView::getLatestBaseFiles, this.secondaryView::getLatestBaseFiles);
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionPath, String maxCommitTime) {
        return this.execute(partitionPath, maxCommitTime, this.preferredView::getLatestBaseFilesBeforeOrOn, this.secondaryView::getLatestBaseFilesBeforeOrOn);
    }

    @Override
    public Map<String, Stream<HoodieBaseFile>> getAllLatestBaseFilesBeforeOrOn(String maxCommitTime) {
        return this.execute(maxCommitTime, this.preferredView::getAllLatestBaseFilesBeforeOrOn, this.secondaryView::getAllLatestBaseFilesBeforeOrOn);
    }

    @Override
    public Option<HoodieBaseFile> getLatestBaseFile(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestBaseFile, this.secondaryView::getLatestBaseFile);
    }

    @Override
    public Option<HoodieBaseFile> getBaseFileOn(String partitionPath, String instantTime, String fileId) {
        return this.execute(partitionPath, instantTime, fileId, this.preferredView::getBaseFileOn, this.secondaryView::getBaseFileOn);
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestBaseFilesInRange, this.secondaryView::getLatestBaseFilesInRange);
    }

    @Override
    public void loadAllPartitions() {
        this.execute(() -> {
            this.preferredView.loadAllPartitions();
            return null;
        }, () -> {
            this.secondaryView.loadAllPartitions();
            return null;
        });
    }

    @Override
    public void loadPartitions(List<String> partitionPaths) {
        this.execute(() -> {
            this.preferredView.loadPartitions(partitionPaths);
            return null;
        }, () -> {
            this.secondaryView.loadPartitions(partitionPaths);
            return null;
        });
    }

    @Override
    public Stream<HoodieBaseFile> getAllBaseFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllBaseFiles, this.secondaryView::getAllBaseFiles);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlices, this.secondaryView::getLatestFileSlices);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesStateless(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlicesStateless, this.secondaryView::getLatestFileSlicesStateless);
    }

    @Override
    public Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestUnCompactedFileSlices, this.secondaryView::getLatestUnCompactedFileSlices);
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        return this.execute(partitionPath, maxCommitTime, includeFileSlicesInPendingCompaction, this.preferredView::getLatestFileSlicesBeforeOrOn, this.secondaryView::getLatestFileSlicesBeforeOrOn);
    }

    @Override
    public Map<String, Stream<FileSlice>> getAllLatestFileSlicesBeforeOrOn(String maxCommitTime) {
        return this.execute(maxCommitTime, this.preferredView::getAllLatestFileSlicesBeforeOrOn, this.secondaryView::getAllLatestFileSlicesBeforeOrOn);
    }

    @Override
    public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionPath, String maxInstantTime) {
        return this.execute(partitionPath, maxInstantTime, this.preferredView::getLatestMergedFileSlicesBeforeOrOn, this.secondaryView::getLatestMergedFileSlicesBeforeOrOn);
    }

    @Override
    public Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestFileSliceInRange, this.secondaryView::getLatestFileSliceInRange);
    }

    @Override
    public Stream<FileSlice> getAllFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileSlices, this.secondaryView::getAllFileSlices);
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileGroups, this.secondaryView::getAllFileGroups);
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroupsStateless(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileGroupsStateless, this.secondaryView::getAllFileGroupsStateless);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBeforeOrOn(String maxCommitTime, String partitionPath) {
        return this.execute(maxCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsBeforeOrOn, this.secondaryView::getReplacedFileGroupsBeforeOrOn);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBefore(String maxCommitTime, String partitionPath) {
        return this.execute(maxCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsBefore, this.secondaryView::getReplacedFileGroupsBefore);
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsAfterOrOn(String minCommitTime, String partitionPath) {
        return this.execute(minCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsAfterOrOn, this.secondaryView::getReplacedFileGroupsAfterOrOn);
    }

    @Override
    public Stream<HoodieFileGroup> getAllReplacedFileGroups(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllReplacedFileGroups, this.secondaryView::getAllReplacedFileGroups);
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        return this.execute(this.preferredView::getPendingCompactionOperations, this.secondaryView::getPendingCompactionOperations);
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingLogCompactionOperations() {
        return this.execute(this.preferredView::getPendingLogCompactionOperations, this.secondaryView::getPendingLogCompactionOperations);
    }

    @Override
    public Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClustering() {
        return this.execute(this.preferredView::getFileGroupsInPendingClustering, this.secondaryView::getFileGroupsInPendingClustering);
    }

    @Override
    public void close() {
        this.preferredView.close();
        this.secondaryView.close();
    }

    @Override
    public void reset() {
        this.preferredView.reset();
        this.secondaryView.reset();
        this.errorOnPreferredView = false;
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.execute(this.preferredView::getLastInstant, this.secondaryView::getLastInstant);
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.execute(this.preferredView::getTimeline, this.secondaryView::getTimeline);
    }

    @Override
    public void sync() {
        this.preferredView.sync();
        this.secondaryView.sync();
        this.errorOnPreferredView = false;
    }

    @Override
    public Option<FileSlice> getLatestFileSlice(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestFileSlice, this.secondaryView::getLatestFileSlice);
    }

    public SyncableFileSystemView getPreferredView() {
        return this.preferredView;
    }

    public SyncableFileSystemView getSecondaryView() {
        return this.secondaryView;
    }
}

