/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.dto.FileStatusDTO;
import org.apache.hudi.storage.StoragePathInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogFileDTO {
    @JsonProperty(value="fileStatus")
    private FileStatusDTO fileStatus;
    @JsonProperty(value="path")
    private String pathStr;
    @JsonProperty(value="len")
    private long fileLen;

    public static HoodieLogFile toHoodieLogFile(LogFileDTO dto) {
        StoragePathInfo pathInfo = FileStatusDTO.toStoragePathInfo(dto.fileStatus);
        HoodieLogFile logFile = pathInfo == null ? new HoodieLogFile(dto.pathStr) : new HoodieLogFile(pathInfo);
        logFile.setFileLen(dto.fileLen);
        return logFile;
    }

    public static LogFileDTO fromHoodieLogFile(HoodieLogFile dataFile) {
        LogFileDTO logFile = new LogFileDTO();
        logFile.fileLen = dataFile.getFileSize();
        logFile.pathStr = dataFile.getPath().toString();
        logFile.fileStatus = FileStatusDTO.fromStoragePathInfo(dataFile.getPathInfo());
        return logFile;
    }
}

