/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.AppendResult;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.HoodieLogFileWriteCallback;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HoodieLogFormat {
    public static final byte[] MAGIC = new byte[]{35, 72, 85, 68, 73, 35};
    public static final int CURRENT_VERSION = 1;
    public static final String UNKNOWN_WRITE_TOKEN = "1-0-1";
    public static final String DEFAULT_WRITE_TOKEN = "0-0-0";
    public static final String DEFAULT_LOG_FORMAT_WRITER = "org.apache.hudi.common.table.log.HoodieLogFormatWriter";

    public static WriterBuilder newWriterBuilder() {
        return new WriterBuilder();
    }

    public static Reader newReader(HoodieStorage storage, HoodieLogFile logFile, Schema readerSchema) throws IOException {
        return new HoodieLogFileReader(storage, logFile, readerSchema, 0x1000000);
    }

    public static Reader newReader(HoodieStorage storage, HoodieLogFile logFile, Schema readerSchema, boolean reverseReader) throws IOException {
        return new HoodieLogFileReader(storage, logFile, readerSchema, 0x1000000, reverseReader);
    }

    public static abstract class LogFormatVersion {
        private final int version;

        LogFormatVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }

        public abstract boolean hasMagicHeader();

        public abstract boolean hasContent();

        public abstract boolean hasContentLength();

        public abstract boolean hasOrdinal();

        public abstract boolean hasHeader();

        public abstract boolean hasFooter();

        public abstract boolean hasLogBlockLength();
    }

    public static class WriterBuilder {
        private static final Logger LOG = LoggerFactory.getLogger(WriterBuilder.class);
        public static final long DEFAULT_SIZE_THRESHOLD = 0x20000000L;
        private Integer bufferSize;
        private Short replication;
        private HoodieStorage storage;
        private Long sizeThreshold;
        private String fileExtension;
        private String logFileId;
        private String instantTime;
        private Integer logVersion;
        private Long fileLen = 0L;
        private StoragePath parentPath;
        private String logWriteToken;
        private String suffix;
        private String rolloverLogWriteToken;
        private HoodieLogFileWriteCallback logFileWriteCallback;

        public WriterBuilder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public WriterBuilder withReplication(short replication) {
            this.replication = replication;
            return this;
        }

        public WriterBuilder withRolloverLogWriteToken(String rolloverLogWriteToken) {
            this.rolloverLogWriteToken = rolloverLogWriteToken;
            return this;
        }

        public WriterBuilder withLogWriteToken(String logWriteToken) {
            this.logWriteToken = logWriteToken;
            return this;
        }

        public WriterBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public WriterBuilder withStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        public WriterBuilder withSizeThreshold(long sizeThreshold) {
            this.sizeThreshold = sizeThreshold;
            return this;
        }

        public WriterBuilder withFileExtension(String logFileExtension) {
            this.fileExtension = logFileExtension;
            return this;
        }

        public WriterBuilder withFileId(String fileId) {
            this.logFileId = fileId;
            return this;
        }

        public WriterBuilder overBaseCommit(String baseCommit) {
            this.instantTime = baseCommit;
            return this;
        }

        public WriterBuilder withLogVersion(int version) {
            this.logVersion = version;
            return this;
        }

        public WriterBuilder withLogWriteCallback(HoodieLogFileWriteCallback logFileWriteCallback) {
            this.logFileWriteCallback = logFileWriteCallback;
            return this;
        }

        public WriterBuilder withFileSize(long fileLen) {
            this.fileLen = fileLen;
            return this;
        }

        public WriterBuilder onParentPath(StoragePath parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        public Writer build() throws IOException {
            LOG.info("Building HoodieLogFormat Writer");
            if (this.storage == null) {
                throw new IllegalArgumentException("fs is not specified");
            }
            if (this.logFileId == null) {
                throw new IllegalArgumentException("FileID is not specified");
            }
            if (this.instantTime == null) {
                throw new IllegalArgumentException("BaseCommitTime is not specified");
            }
            if (this.fileExtension == null) {
                throw new IllegalArgumentException("File extension is not specified");
            }
            if (this.parentPath == null) {
                throw new IllegalArgumentException("Log file parent location is not specified");
            }
            if (this.rolloverLogWriteToken == null) {
                this.rolloverLogWriteToken = HoodieLogFormat.UNKNOWN_WRITE_TOKEN;
            }
            if (this.logFileWriteCallback == null) {
                this.logFileWriteCallback = new HoodieLogFileWriteCallback(){};
            }
            if (this.logVersion == null) {
                LOG.info("Computing the next log version for " + this.logFileId + " in " + this.parentPath);
                Option<Pair<Integer, String>> versionAndWriteToken = FSUtils.getLatestLogVersion(this.storage, this.parentPath, this.logFileId, this.fileExtension, this.instantTime);
                if (versionAndWriteToken.isPresent()) {
                    this.logVersion = (Integer)((Pair)versionAndWriteToken.get()).getKey();
                    this.logWriteToken = (String)((Pair)versionAndWriteToken.get()).getValue();
                } else {
                    this.logVersion = HoodieLogFile.LOGFILE_BASE_VERSION;
                    this.logWriteToken = this.rolloverLogWriteToken;
                }
                LOG.info("Computed the next log version for {} in {} as {} with write-token {}", new Object[]{this.logFileId, this.parentPath, this.logVersion, this.logWriteToken});
            }
            if (this.logWriteToken == null) {
                this.logVersion = this.logVersion + 1;
                this.fileLen = 0L;
                this.logWriteToken = this.rolloverLogWriteToken;
            }
            if (this.suffix != null) {
                this.logWriteToken = this.logWriteToken + this.suffix;
                this.rolloverLogWriteToken = this.rolloverLogWriteToken + this.suffix;
            }
            StoragePath logPath = new StoragePath(this.parentPath, FSUtils.makeLogFileName(this.logFileId, this.fileExtension, this.instantTime, this.logVersion, this.logWriteToken));
            LOG.info("HoodieLogFile on path {}", (Object)logPath);
            HoodieLogFile logFile = new HoodieLogFile(logPath, this.fileLen);
            if (this.sizeThreshold == null) {
                this.sizeThreshold = 0x20000000L;
            }
            return (Writer)ReflectionUtils.loadClass((String)HoodieLogFormat.DEFAULT_LOG_FORMAT_WRITER, (Class[])new Class[]{HoodieStorage.class, HoodieLogFile.class, Integer.class, Short.class, Long.class, String.class, HoodieLogFileWriteCallback.class}, (Object[])new Object[]{this.storage, logFile, this.bufferSize, this.replication, this.sizeThreshold, this.rolloverLogWriteToken, this.logFileWriteCallback});
        }
    }

    public static interface Reader
    extends Closeable,
    Iterator<HoodieLogBlock> {
        public HoodieLogFile getLogFile();

        public boolean hasPrev();

        public HoodieLogBlock prev() throws IOException;
    }

    public static interface Writer
    extends Closeable {
        public HoodieLogFile getLogFile();

        public AppendResult appendBlock(HoodieLogBlock var1) throws IOException, InterruptedException;

        public AppendResult appendBlocks(List<HoodieLogBlock> var1) throws IOException, InterruptedException;

        public long getCurrentSize() throws IOException;
    }
}

