/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Timestamp-based key generator configs", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.KEY_GENERATOR, description="Configs used for TimestampBasedKeyGenerator which relies on timestamps for the partition field. The field values are interpreted as timestamps and not just converted to string while generating partition path value for records. Record key is same as before where it is chosen by field name.")
public class TimestampKeyGeneratorConfig
extends HoodieConfig {
    private static final String TIMESTAMP_KEYGEN_CONFIG_PREFIX = "hoodie.keygen.timebased.";
    @Deprecated
    private static final String OLD_TIMESTAMP_KEYGEN_CONFIG_PREFIX = "hoodie.deltastreamer.keygen.timebased.";
    public static final ConfigProperty<String> TIMESTAMP_TYPE_FIELD = ConfigProperty.key("hoodie.keygen.timebased.timestamp.type").noDefaultValue().withAlternatives("hoodie.deltastreamer.keygen.timebased.timestamp.type").markAdvanced().withDocumentation("Timestamp type of the field, which should be one of the timestamp types supported: `UNIX_TIMESTAMP`, `DATE_STRING`, `MIXED`, `EPOCHMILLISECONDS`, `SCALAR`.");
    public static final ConfigProperty<String> INPUT_TIME_UNIT = ConfigProperty.key("hoodie.keygen.timebased.timestamp.scalar.time.unit").defaultValue(TimeUnit.SECONDS.toString()).withAlternatives("hoodie.deltastreamer.keygen.timebased.timestamp.scalar.time.unit").markAdvanced().withDocumentation("When timestamp type `SCALAR` is used, this specifies the time unit, with allowed unit specified by `TimeUnit` enums (`NANOSECONDS`, `MICROSECONDS`, `MILLISECONDS`, `SECONDS`, `MINUTES`, `HOURS`, `DAYS`).");
    public static final ConfigProperty<String> TIMESTAMP_INPUT_DATE_FORMAT = ConfigProperty.key("hoodie.keygen.timebased.input.dateformat").defaultValue("").withAlternatives("hoodie.deltastreamer.keygen.timebased.input.dateformat").markAdvanced().withDocumentation("Input date format such as `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.");
    public static final ConfigProperty<String> TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX = ConfigProperty.key("hoodie.keygen.timebased.input.dateformat.list.delimiter.regex").defaultValue(",").withAlternatives("hoodie.deltastreamer.keygen.timebased.input.dateformat.list.delimiter.regex").markAdvanced().withDocumentation("The delimiter for allowed input date format list, usually `,`.");
    public static final ConfigProperty<String> TIMESTAMP_INPUT_TIMEZONE_FORMAT = ConfigProperty.key("hoodie.keygen.timebased.input.timezone").defaultValue("UTC").withAlternatives("hoodie.deltastreamer.keygen.timebased.input.timezone").markAdvanced().withDocumentation("Timezone of the input timestamp, such as `UTC`.");
    public static final ConfigProperty<String> TIMESTAMP_OUTPUT_DATE_FORMAT = ConfigProperty.key("hoodie.keygen.timebased.output.dateformat").defaultValue("").withAlternatives("hoodie.deltastreamer.keygen.timebased.output.dateformat").markAdvanced().withDocumentation("Output date format such as `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.");
    public static final ConfigProperty<String> TIMESTAMP_OUTPUT_TIMEZONE_FORMAT = ConfigProperty.key("hoodie.keygen.timebased.output.timezone").defaultValue("UTC").withAlternatives("hoodie.deltastreamer.keygen.timebased.output.timezone").markAdvanced().withDocumentation("Timezone of the output timestamp, such as `UTC`.");
    @Deprecated
    public static final ConfigProperty<String> TIMESTAMP_TIMEZONE_FORMAT = ConfigProperty.key("hoodie.keygen.timebased.timezone").defaultValue("UTC").withAlternatives("hoodie.deltastreamer.keygen.timebased.timezone").markAdvanced().withDocumentation("Timezone of both input and output timestamp if they are the same, such as `UTC`.  Please use `" + TIMESTAMP_INPUT_TIMEZONE_FORMAT.key() + "` and `" + TIMESTAMP_OUTPUT_TIMEZONE_FORMAT.key() + "` instead if the input and output timezones are different.");
    public static final ConfigProperty<String> DATE_TIME_PARSER = ConfigProperty.key("hoodie.keygen.datetime.parser.class").defaultValue("org.apache.hudi.keygen.parser.HoodieDateTimeParser").withAlternatives("hoodie.deltastreamer.keygen.datetime.parser.class").markAdvanced().withDocumentation("Date time parser class name.");
}

