/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.utils.MetadataTableUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieSavepointMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointActionExecutor.class);
    private final String user;
    private final String comment;

    public SavepointActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String user, String comment) {
        super(context, config, table, instantTime);
        this.user = user;
        this.comment = comment;
    }

    @Override
    public HoodieSavepointMetadata execute() {
        if (!this.table.getCompletedCommitsTimeline().containsInstant(this.instantTime)) {
            throw new HoodieSavepointException("Could not savepoint non-existing commit " + this.instantTime);
        }
        try {
            Map latestFilesMap;
            Option cleanInstant = this.table.getCleanTimeline().lastInstant();
            String lastCommitRetained = (String)cleanInstant.map(instant -> {
                try {
                    if (instant.isCompleted()) {
                        return TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])this.table.getActiveTimeline().getInstantDetails(instant).get())).getEarliestCommitToRetain();
                    }
                    return TimelineMetadataUtils.deserializeCleanerPlan((byte[])((byte[])this.table.getActiveTimeline().getInstantDetails(new HoodieInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.getTimestamp())).get())).getEarliestInstantToRetain().getTimestamp();
                }
                catch (IOException e) {
                    throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
                }
            }).orElseGet(() -> ((HoodieInstant)this.table.getCompletedCommitsTimeline().firstInstant().get()).getTimestamp());
            ValidationUtils.checkArgument((boolean)HoodieTimeline.compareTimestamps((String)this.instantTime, (BiPredicate)HoodieTimeline.GREATER_THAN_OR_EQUALS, (String)lastCommitRetained), (String)("Could not savepoint commit " + this.instantTime + " as this is beyond the lookup window " + lastCommitRetained));
            this.context.setJobStatus(this.getClass().getSimpleName(), "Collecting latest files for savepoint " + this.instantTime + " " + this.table.getConfig().getTableName());
            TableFileSystemView.SliceView view = this.table.getSliceView();
            if (MetadataTableUtils.shouldUseBatchLookup(this.table.getMetaClient().getTableConfig(), this.config)) {
                latestFilesMap = view.getAllLatestFileSlicesBeforeOrOn(this.instantTime).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    ArrayList latestFiles = new ArrayList();
                    ((Stream)entry.getValue()).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return latestFiles;
                }));
            } else {
                List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieStorage)this.table.getStorage(), (HoodieMetadataConfig)this.config.getMetadataConfig(), (String)this.table.getMetaClient().getBasePath());
                latestFilesMap = this.context.mapToPair(partitions, (SerializablePairFunction & Serializable)partitionPath -> {
                    LOG.info("Collecting latest files in partition path " + partitionPath);
                    ArrayList latestFiles = new ArrayList();
                    view.getLatestFileSlicesBeforeOrOn(partitionPath, this.instantTime, true).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return new ImmutablePair(partitionPath, latestFiles);
                }, null);
            }
            HoodieSavepointMetadata metadata = TimelineMetadataUtils.convertSavepointMetadata((String)this.user, (String)this.comment, latestFilesMap);
            this.table.getActiveTimeline().createNewInstant(new HoodieInstant(true, "savepoint", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(new HoodieInstant(true, "savepoint", this.instantTime), TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)metadata));
            LOG.info("Savepoint " + this.instantTime + " created");
            return metadata;
        }
        catch (IOException e) {
            throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
        }
    }
}

