/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieRollbackRequest;

public class SerializableHoodieRollbackRequest
implements Serializable {
    private final String partitionPath;
    private final String fileId;
    private final String latestBaseInstant;
    private final List<String> filesToBeDeleted = new ArrayList<String>();
    private final Map<String, Long> logBlocksToBeDeleted = new HashMap<String, Long>();

    public SerializableHoodieRollbackRequest(HoodieRollbackRequest rollbackRequest) {
        this.partitionPath = rollbackRequest.getPartitionPath();
        this.fileId = rollbackRequest.getFileId();
        this.latestBaseInstant = rollbackRequest.getLatestBaseInstant();
        this.filesToBeDeleted.addAll(rollbackRequest.getFilesToBeDeleted());
        this.logBlocksToBeDeleted.putAll(rollbackRequest.getLogBlocksToBeDeleted());
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getLatestBaseInstant() {
        return this.latestBaseInstant;
    }

    public List<String> getFilesToBeDeleted() {
        return this.filesToBeDeleted;
    }

    public Map<String, Long> getLogBlocksToBeDeleted() {
        return this.logBlocksToBeDeleted;
    }
}

