/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.joda.time.DateTime;

public class ClusteringPlanPartitionFilter {
    public static List<String> filter(List<String> partitions, HoodieWriteConfig config) {
        ClusteringPlanPartitionFilterMode mode = config.getClusteringPlanPartitionFilterMode();
        switch (mode) {
            case NONE: {
                return partitions;
            }
            case RECENT_DAYS: {
                return ClusteringPlanPartitionFilter.recentDaysFilter(partitions, config);
            }
            case SELECTED_PARTITIONS: {
                return ClusteringPlanPartitionFilter.selectedPartitionsFilter(partitions, config);
            }
            case DAY_ROLLING: {
                return ClusteringPlanPartitionFilter.dayRollingFilter(partitions, config);
            }
        }
        throw new HoodieClusteringException("Unknown partition filter, filter mode: " + (Object)((Object)mode));
    }

    private static List<String> dayRollingFilter(List<String> partitions, HoodieWriteConfig config) {
        int hour = DateTime.now().getHourOfDay();
        int len = partitions.size();
        ArrayList<String> selectPt = new ArrayList<String>();
        partitions.sort(String::compareTo);
        for (int i = 0; i < len; ++i) {
            if (i % 24 != hour) continue;
            selectPt.add(partitions.get(i));
        }
        return selectPt;
    }

    private static List<String> recentDaysFilter(List<String> partitions, HoodieWriteConfig config) {
        int targetPartitionsForClustering = config.getTargetPartitionsForClustering();
        int skipPartitionsFromLatestForClustering = config.getSkipPartitionsFromLatestForClustering();
        return partitions.stream().sorted(Comparator.reverseOrder()).skip(Math.max(skipPartitionsFromLatestForClustering, 0)).limit(targetPartitionsForClustering > 0 ? (long)targetPartitionsForClustering : (long)partitions.size()).collect(Collectors.toList());
    }

    private static List<String> selectedPartitionsFilter(List<String> partitions, HoodieWriteConfig config) {
        String endPartition;
        Stream<Object> filteredPartitions = partitions.stream();
        String beginPartition = config.getBeginPartitionForClustering();
        if (beginPartition != null) {
            filteredPartitions = filteredPartitions.filter(path -> path.compareTo(beginPartition) >= 0);
        }
        if ((endPartition = config.getEndPartitionForClustering()) != null) {
            filteredPartitions = filteredPartitions.filter(path -> path.compareTo(endPartition) <= 0);
        }
        return filteredPartitions.collect(Collectors.toList());
    }
}

